package dev.amble.ait;

import static dev.amble.ait.module.planet.core.space.planet.Crater.CRATER_ID;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;

import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.register.AmbleRegistries;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.drtheo.multidim.MultiDim;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1311;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3133;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_55;
import net.minecraft.class_6796;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import dev.amble.ait.api.AITModInitializer;
import dev.amble.ait.config.AITServerConfig;
import dev.amble.ait.core.*;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.commands.*;
import dev.amble.ait.core.drinks.DrinkRegistry;
import dev.amble.ait.core.engine.registry.SubSystemRegistry;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.entities.RiftEntity;
import dev.amble.ait.core.item.blueprint.BlueprintRegistry;
import dev.amble.ait.core.item.component.AbstractTardisPart;
import dev.amble.ait.core.item.part.MachineItem;
import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.lock.LockedDimensionRegistry;
import dev.amble.ait.core.loot.SetBlueprintLootFunction;
import dev.amble.ait.core.sounds.flight.FlightSoundRegistry;
import dev.amble.ait.core.sounds.travel.TravelSoundRegistry;
import dev.amble.ait.core.tardis.animation.v2.blockbench.BlockbenchParser;
import dev.amble.ait.core.tardis.animation.v2.datapack.TardisAnimationRegistry;
import dev.amble.ait.core.tardis.control.sound.ControlSoundRegistry;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.tardis.vortex.reference.VortexReferenceRegistry;
import dev.amble.ait.core.util.CustomTrades;
import dev.amble.ait.core.util.SpaceUtils;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.schema.MachineRecipeSchema;
import dev.amble.ait.module.ModuleRegistry;
import dev.amble.ait.module.planet.core.space.planet.Crater;
import dev.amble.ait.registry.impl.*;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class AITMod implements ModInitializer {

    public static final String MOD_ID = "ait";
    public static final Logger LOGGER = LoggerFactory.getLogger("ait");
    public static final Random RANDOM = new Random();

    public static AITServerConfig CONFIG;
    public static final class_1928.class_4313<class_1928.class_4310> STASER_GRIEFING = GameRuleRegistry.register("staserGriefing",
            class_1928.class_5198.field_24100, GameRuleFactory.createBooleanRule(true));

    public static final class_1928.class_4313<class_1928.class_4310> TARDIS_GRIEFING = GameRuleRegistry.register("tardisGriefing",
            class_1928.class_5198.field_24100, GameRuleFactory.createBooleanRule(true));

    public static final class_1928.class_4313<class_1928.class_4310> TARDIS_FIRE_GRIEFING = GameRuleRegistry.register("tardisFireGriefing",
            class_1928.class_5198.field_24100, GameRuleFactory.createBooleanRule(false));


    public static final class_5321<class_6796> CUSTOM_GEODE_PLACED_KEY = class_5321.method_29179(class_7924.field_41245,
            new class_2960(MOD_ID, "zeiton_geode"));

    // This DefaultParticleType gets called when you want to use your particle in code.
    public static final class_2400 CORAL_PARTICLE = FabricParticleTypes.simple();

    // This is the Crater feature that generates in the world. It's made with AI so it sucks lol
    public static final Crater CRATER = new Crater(class_3133.field_24899);

    public static final String BRANCH;

    static {
        // ait-1.x.xx-BRANCH+mc.1.20.1
        String version = FabricLoader.getInstance().getModContainer(MOD_ID).get().getMetadata().getVersion().getFriendlyString();
        // get the part of the version string between the - and +
        BRANCH = version.substring(version.indexOf("-"), version.lastIndexOf("-"));
    }

    public static boolean isUnsafeBranch() {
        return !BRANCH.contains("release");
    }

    public void registerParticles() {
        class_2378.method_10230(class_7923.field_41180, id("coral_particle"), CORAL_PARTICLE);
    }

    @Override
    public void onInitialize() {
        AITServerConfig.INSTANCE.load();
        CONFIG = AITServerConfig.INSTANCE.instance();

        ServerLifecycleHooks.init();
        AsyncLocatorUtil.init();
        MultiDim.init();

        CreakRegistry.init();
        SequenceRegistry.init();
        MoodEventPoolRegistry.init();
        LandingPadManager.init();
        ControlRegistry.init();
        RiftChunkManager.init();

        AmbleRegistries.getInstance().registerAll(
                ConsoleRegistry.getInstance(),
                SonicRegistry.getInstance(),
                DesktopRegistry.getInstance(),
                ConsoleVariantRegistry.getInstance(),
                MachineRecipeRegistry.getInstance(),
                TravelSoundRegistry.getInstance(),
                FlightSoundRegistry.getInstance(),
                VortexReferenceRegistry.getInstance(),
                BlueprintRegistry.getInstance(),
                ExteriorVariantRegistry.getInstance(),
                CategoryRegistry.getInstance(),
                TardisComponentRegistry.getInstance(),
                LockedDimensionRegistry.getInstance(),
                HumRegistry.getInstance(),
                SubSystemRegistry.getInstance(),
                ItemOpinionRegistry.getInstance(),
                DrinkRegistry.getInstance(),
                TardisAnimationRegistry.getInstance(),
                DoorRegistry.getInstance()
        );
        ControlSoundRegistry.init();
        BlockbenchParser.init();

        registerParticles();

        // For all the addon devs
        FabricLoader.getInstance().invokeEntrypoints("ait-main", AITModInitializer.class,
                AITModInitializer::onInitializeAIT);

        HandlesResponseRegistry.init();

        AITStatusEffects.init();
        AITVillagers.init();
        AITArgumentTypes.register();
        AITSounds.init();
        AITDimensions.init();

        CustomTrades.register();

        RegistryContainer.register(AITItemGroups.class, MOD_ID);
        RegistryContainer.register(AITItems.class, MOD_ID);
        RegistryContainer.register(AITBlocks.class, MOD_ID);
        RegistryContainer.register(AITBlockEntityTypes.class, MOD_ID);
        RegistryContainer.register(AITEntityTypes.class, MOD_ID);
        RegistryContainer.register(AITPaintings.class, MOD_ID);
        ModuleRegistry.instance().onCommonInit();

        BlueprintRegistry.BLUEPRINT_TYPE = class_2378.method_10230(class_7923.field_41134,
                AITMod.id("set_blueprint"),
                new class_5339(new SetBlueprintLootFunction.Serializer()));

        WorldUtil.init();
        TardisUtil.init();

        ServerTardisManager.init();
        TardisCriterions.init();

        entityAttributeRegister();

        BiomeModifications.addFeature(BiomeSelectors.foundInOverworld(), class_2893.class_2895.field_13176,
                CUSTOM_GEODE_PLACED_KEY);

        BiomeModifications.addSpawn(
                BiomeSelectors.all(),
                class_1311.field_6303,
                AITEntityTypes.RIFT_ENTITY,
                4,
                1,
                1
        );

        class_2378.method_10230(net.minecraft.class_7923.field_41144, CRATER_ID, CRATER);

        CommandRegistrationCallback.EVENT.register(((dispatcher, registryAccess, environment) -> {
            TeleportInteriorCommand.register(dispatcher);
            SummonTardisCommand.register(dispatcher);
            SetLockedCommand.register(dispatcher);
            ThisTardisCommand.register(dispatcher);
            FuelCommand.register(dispatcher);
            SetRepairTicksCommand.register(dispatcher);
            RiftChunkCommand.register(dispatcher);
            ScaleCommand.register(dispatcher);
            TriggerMoodRollCommand.register(dispatcher);
            SetNameCommand.register(dispatcher);
            GetNameCommand.register(dispatcher);
            GetCreatorCommand.register(dispatcher);
            SetMaxSpeedCommand.register(dispatcher);
            SetSiegeCommand.register(dispatcher);
            LinkCommand.register(dispatcher);
            UnLinkCommand.register(dispatcher);
            RemoveCommand.register(dispatcher);
            PermissionCommand.register(dispatcher);
            LoyaltyCommand.register(dispatcher);
            UnlockCommand.register(dispatcher);
            DataCommand.register(dispatcher);
            TravelDebugCommand.register(dispatcher);
            VersionCommand.register(dispatcher);
            SafePosCommand.register(dispatcher);
            ListCommand.register(dispatcher);
            LoadCommand.register(dispatcher);
            DebugCommand.register(dispatcher);
            EraseChunksCommand.register(dispatcher);
            FlightCommand.register(dispatcher);
            SetDoorParticleCommand.register(dispatcher, registryAccess);
        }));

        ServerPlayNetworking.registerGlobalReceiver(TardisUtil.REGION_LANDING_CODE,
                (server, player, handler, buf, responseSender) -> {
                    class_2338 pos = buf.method_10811();
                    String landingCode = buf.method_19772();

                    server.execute(() -> {
                        LandingPadRegion region = LandingPadManager.getInstance((class_3218) player.method_37908()).getRegionAt(pos);

                        if (region == null)
                            return;

                        region.setLandingCode(landingCode);
                        LandingPadManager.Network.syncTracked(LandingPadManager.Network.Action.ADD, player.method_51469(),
                                new class_1923(player.method_24515()));
                    });
                });

        ServerPlayNetworking.registerGlobalReceiver(MachineItem.MACHINE_DISASSEMBLE,
                (server, player, handler, buf, responseSender) -> {
                    class_1799 machine = buf.method_10819();

                    Optional<MachineRecipeSchema> schema = MachineRecipeRegistry.getInstance().findMatching(machine);

                    if (schema.isEmpty())
                        return;

                    // this should ALWAYS be executed on the main thread
                    server.execute(() -> {
                        MachineItem.disassemble(player, machine, schema.get());

                        StackUtil.playBreak(player);
                    });
                });

        ServerPlayNetworking.registerGlobalReceiver(AbstractTardisPart.DISASSEMBLE,
                (server, player, handler, buf, responseSender) -> {
                    class_1799 machine = buf.method_10819();

                    Optional<MachineRecipeSchema> schema = MachineRecipeRegistry.getInstance().findMatching(machine);

                    if (schema.isEmpty())
                        return;

                    // this should ALWAYS be executed on the main thread
                    server.execute(() -> {
                        AbstractTardisPart.disassemble(player, machine, schema.get());

                        StackUtil.playBreak(player);
                    });
                });

        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (source.isBuiltin()
                    && (id.equals(class_39.field_615) || id.equals(class_39.field_885)
                    || id.equals(class_39.field_17009) || id.equals(class_39.field_24050))
                    || id.equals(class_39.field_274) || id.equals(class_39.field_841)
                    || id.equals(class_39.field_472) || id.equals(class_39.field_16751)
                    || id.equals(class_39.field_17107) || id.equals(class_39.field_665)
                    || id.equals(class_39.field_38438) || id.equals(class_39.field_38439)
                    || id.equals(class_39.field_251) || id.equals(class_39.field_43354)
                    || id.equals(class_39.field_43353) || id.equals(class_39.field_43357)
                    || id.equals(class_39.field_43356) || id.equals(class_39.field_44649)
                    || id.equals(class_39.field_854) || id.equals(class_39.field_885)
                    || id.equals(class_39.field_356) || id.equals(class_39.field_683)) {


                class_55.class_56 poolBuilder = class_55.method_347().method_351(class_77.method_411(AITItems.BLUEPRINT).method_438(SetBlueprintLootFunction.random()).method_437(10));

                tableBuilder.method_336(poolBuilder);
            }
        });
    }

    public void entityAttributeRegister() {
        FabricDefaultAttributeRegistry.register(AITEntityTypes.RIFT_ENTITY,
                RiftEntity.method_26828());

        FabricDefaultAttributeRegistry.register(AITEntityTypes.FLIGHT_TARDIS_TYPE,
                FlightTardisEntity.createDummyAttributes());
    }

    public static final class_2960 OPEN_SCREEN = AITMod.id("open_screen");
    public static final class_2960 OPEN_SCREEN_TARDIS = AITMod.id("open_screen_tardis");
    public static final class_2960 OPEN_SCREEN_CONSOLE = AITMod.id("open_screen_console");

    public static void openScreen(class_3222 player, int id) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        ServerPlayNetworking.send(player, OPEN_SCREEN, buf);
    }

    public static void openScreen(class_3222 player, int id, UUID tardis) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10797(tardis);
        ServerPlayNetworking.send(player, OPEN_SCREEN_TARDIS, buf);
    }

    public static void openScreen(class_3222 player, int id, UUID tardis, class_2338 console) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10797(tardis);
        buf.method_10807(console);

        ServerPlayNetworking.send(player, OPEN_SCREEN_CONSOLE, buf);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }
}
