package dev.amble.ait.api;

import net.minecraft.class_1799;
import net.minecraft.class_2487;

public interface ArtronHolderItem {
    String FUEL_KEY = "fuel";

    default double getCurrentFuel(class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        if (!nbt.method_10545(this.getFuelKey())) {
            this.setCurrentFuel(0, stack);
            return 0;
        }

        return nbt.method_10574(this.getFuelKey());
    }

    default void setCurrentFuel(double var, class_1799 stack) {
        class_2487 nbt = stack.method_7948();

        nbt.method_10549(this.getFuelKey(), var <= 0 ? 0 : var);
    }

    default double addFuel(double val, class_1799 stack) {
        double current = this.getCurrentFuel(stack);
        double max = this.getMaxFuel(stack);

        this.setCurrentFuel(Math.min(current + val, max), stack);
        return 0;
    }

    default void removeFuel(double var, class_1799 stack) {
        double current = this.getCurrentFuel(stack);

        if (current - var < 0) {
            this.setCurrentFuel(0, stack);
            return;
        }
        this.setCurrentFuel(current - var, stack);
    }

    double getMaxFuel(class_1799 stack);

    default boolean isOutOfFuel(class_1799 stack) {
        return this.getCurrentFuel(stack) <= 0;
    }

    default boolean hasMaxFuel(class_1799 stack) {
        return this.getCurrentFuel(stack) >= this.getMaxFuel(stack);
    }

    default String getFuelKey() {
        return FUEL_KEY;
    }
}
