package dev.amble.ait.api;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

/**
 * Implement this in a Block to allow external systems (like hoppers)
 * to insert items directly into the block, without needing a block entity.
 */
public interface ConsumableBlock {

    /**
     * Returns true if the block can accept the item stack from the specified direction.
     */
    default boolean canAcceptItem(class_1937 world, class_2338 pos, class_1799 stack, class_2350 from) {
        return true;
    }

    /**
     * Attempts to insert the given item into the block from the given direction.
     *
     * @param world World context
     * @param pos Block position
     * @param stack Stack to insert
     * @param from Direction the item is inserted from
     * @param simulate If true, the insertion should only be simulated
     * @return The remaining stack (not inserted), or ItemStack.EMPTY if fully consumed
     */
    class_1799 insertItem(class_1937 world, class_2338 pos, class_1799 stack, class_2350 from, boolean simulate);
}
