package dev.amble.ait.api.tardis.link;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;

public abstract class LinkableEntity extends class_1297 {

    public static final class_2940<Optional<UUID>> TARDIS_ID  = class_2945.method_12791(
            LinkableEntity.class, class_2943.field_13313);

    private TardisRef cache;

    protected LinkableEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5749(class_2487 nbt) { }

    @Override
    protected void method_5652(class_2487 nbt) { }

    public void link(ServerTardis tardis) {
        this.field_6011.method_12778(TARDIS_ID, Optional.of(tardis.getUuid()));
        this.createCache(tardis.getUuid());
    }

    private void reloadCache() {
        UUID id = this.tardisId().orElse(null);

        if (id == null)
            return;

        this.createCache(id);
    }

    private void createCache(UUID id) {
        this.cache = TardisRef.createAs(this, id);
    }

    @Override
    protected void method_5693() {
        this.field_6011.method_12784(TARDIS_ID, Optional.empty());
    }

    @Override
    public void method_5674(class_2940<?> data) {
        super.method_5674(data);

        if (TARDIS_ID.equals(data))
            this.reloadCache();
    }

    public Tardis tardis() {
        if (this.cache != null)
            return cache.get();

        this.reloadCache();
        return cache != null ? cache.get() : null;
    }

    private Optional<UUID> tardisId() {
        return this.field_6011.method_12789(TARDIS_ID);
    }
}
