package dev.amble.ait.api.tardis.link.v2.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.core.tardis.Tardis;

public interface AbstractLinkableEntity extends Linkable {

    class_1937 getWorld();

    class_2945 getDataTracker();

    class_2940<Optional<UUID>> getTracked();

    TardisRef asRef();

    void setRef(TardisRef ref);

    @Override
    default void link(UUID id) {
        this.setRef(TardisRef.createAs(this.getWorld(), id));
        this.getDataTracker().method_12778(this.getTracked(), Optional.ofNullable(id));
    }

    @Override
    default void link(Tardis tardis) {
        this.setRef(TardisRef.createAs(this.getWorld(), tardis));
        this.getDataTracker().method_12778(this.getTracked(), Optional.of(tardis.getUuid()));
    }

    @Override
    default TardisRef tardis() {
        TardisRef result = this.asRef();

        if (result == null) {
            this.link(this.getDataTracker().method_12789(this.getTracked()).orElse(null));
            return this.tardis();
        }

        return result;
    }

    default void initDataTracker() {
        this.getDataTracker().method_12784(this.getTracked(), Optional.empty());
    }

    default void onTrackedDataSet(class_2940<?> data) {
        if (!this.getTracked().equals(data))
            return;

        this.link(this.getDataTracker().method_12789(this.getTracked()).orElse(null));
    }

    default void readCustomDataFromNbt(class_2487 nbt) {
        class_2520 id = nbt.method_10580("tardis");

        if (id == null)
            return;

        this.link(class_2512.method_25930(id));

        if (this.getWorld() == null)
            return;

        this.onLinked();
    }

    default void writeCustomDataToNbt(class_2487 nbt) {
        TardisRef ref = this.asRef();

        if (ref != null && ref.getId() != null)
            nbt.method_25927("tardis", ref.getId());
    }

    static <T extends class_1297 & AbstractLinkableEntity> class_2940<Optional<UUID>> register(Class<T> self) {
        return class_2945.method_12791(self, class_2943.field_13313);
    }
}
