package dev.amble.ait.client.animation;

import net.minecraft.class_7179;
import org.joml.Vector3f;

public class AnimationConstants {

    // Used to fix the STEP interpolation type for Blockbench's keyframes
    public static final class_7179.class_7180 STEP = (destination, delta, keyframes, start, end, scale) -> {
        Vector3f vector3f = keyframes[start].comp_601();
        Vector3f vector3f2 = keyframes[end].comp_601();
        return vector3f.lerp(vector3f2, 0, destination).mul(scale);
    };

    // Used to fix the BEZIER interpolation type for Blockbench's keyframes
    public static final class_7179.class_7180 BEZIER = (destination, delta, keyframes, start, end, scale) -> {
        Vector3f p0 = keyframes[start].comp_601();
        Vector3f p1 = keyframes[start + 1].comp_601();
        Vector3f p2 = keyframes[end - 1].comp_601();
        Vector3f p3 = keyframes[end].comp_601();

        float u = 1 - delta;
        float tt = delta * delta;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * delta;

        Vector3f result = new Vector3f();
        result.add(new Vector3f(p0).mul(uuu));
        result.add(new Vector3f(p1).mul(3 * uu * delta));
        result.add(new Vector3f(p2).mul(3 * u * tt));
        result.add(new Vector3f(p3).mul(ttt));
        return result.mul(scale);
    };
}
