package dev.amble.ait.client.boti;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.renderers.VortexRender;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class TardisDoorBOTI extends BOTI {
    public static void renderInteriorDoorBoti(ClientTardis tardis, DoorBlockEntity door, ClientExteriorVariantSchema variant, class_4587 stack, class_2960 frameTex, AnimatedModel frame, class_630 mask, int light, float tickDelta) {
        ExteriorVariantSchema parent = variant.parent();

        if (class_310.method_1551().field_1687 == null
                || class_310.method_1551().field_1724 == null) return;

        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));

        class_310.method_1551().method_1522().method_1240();

        BOTI_HANDLER.setupFramebuffer();

        class_243 skyColor = class_310.method_1551().field_1687.method_23777(class_310.method_1551().field_1724.method_19538(), class_310.method_1551().method_1488());
        if (AITModClient.CONFIG.greenScreenBOTI)
            BOTI.setFramebufferColor(BOTI_HANDLER.afbo, 0, 1, 0, 1);
        else
            BOTI.setFramebufferColor(BOTI_HANDLER.afbo, (float) skyColor.field_1352, (float) skyColor.field_1351, (float) skyColor.field_1350, 1);

        BOTI.copyFramebuffer(class_310.method_1551().method_1522(), BOTI_HANDLER.afbo);

        class_4597.class_4598 botiProvider = AIT_BUF_BUILDER_STORAGE.getBotiVertexConsumer();

        GL11.glEnable(GL11.GL_STENCIL_TEST);
        GL11.glStencilMask(0xFF);
        GL11.glClear(GL11.GL_STENCIL_BUFFER_BIT);
        GL11.glStencilFunc(GL11.GL_ALWAYS, 1, 0xFF);
        GL11.glStencilOp(GL11.GL_KEEP, GL11.GL_KEEP, GL11.GL_REPLACE);

        RenderSystem.depthMask(true);
        stack.method_22903();
        StatsHandler stats = tardis.stats();
        Vector3f scale = tardis.travel().getScale();

        stack.method_22905((float) parent.portalWidth() * scale.x(),
                (float) parent.portalHeight() * scale.y(), scale.z());
        class_243 vec = parent.door().adjustPortalPos(new class_243(0, -0.55f, 0), class_2350.field_11043);
        stack.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        if (tardis.travel().getState() == TravelHandlerBase.State.LANDED) {
            class_1921 whichOne = AITModClient.CONFIG.greenScreenBOTI ?
                    class_1921.method_49047() : class_1921.method_34571();
            float[] colorsForGreenScreen = AITModClient.CONFIG.greenScreenBOTI ? new float[]{0, 1, 0, 1} : new float[] {(float) skyColor.field_1352, (float) skyColor.field_1351, (float) skyColor.field_1350};
            mask.method_22699(stack, botiProvider.getBuffer(whichOne), 0xf000f0, class_4608.field_21444, colorsForGreenScreen[0], colorsForGreenScreen[1], colorsForGreenScreen[2], 1);
        } else {
            mask.method_22699(stack, botiProvider.getBuffer(class_1921.method_23689(frameTex)), 0xf000f0, class_4608.field_21444, 1, 1, 1, 1);
        }
        botiProvider.method_22993();
        stack.method_22909();
        copyDepth(BOTI_HANDLER.afbo, class_310.method_1551().method_1522());

        BOTI_HANDLER.afbo.method_1235(false);
        GL11.glClear(GL11.GL_DEPTH_BUFFER_BIT);

        GL11.glStencilMask(0x00);
        GL11.glStencilFunc(GL11.GL_EQUAL, 1, 0xFF);

        stack.method_22903();
        if (!tardis.travel().autopilot() && tardis.travel().getState() != TravelHandlerBase.State.LANDED)
            stack.method_22907(class_7833.field_40715.rotationDegrees((float) class_310.method_1551().field_1724.field_6012 / ((float) 200 / tardis.travel().speed()) * 360f));
        if (!tardis.crash().isNormal())
            stack.method_22907(class_7833.field_40714.rotationDegrees((float) class_310.method_1551().field_1724.field_6012 / 100 * 360f));
        stack.method_22907(class_7833.field_40718.rotationDegrees((float) class_310.method_1551().field_1724.field_6012 / 100 * 360f));
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));
        stack.method_46416(0, 0, 500);
        stack.method_22905(1.5f, 1.5f, 1.5f);
        VortexRender util = stats.getVortexEffects().toRender();
        if (!tardis.travel().isLanded() /*&& !tardis.flight().isFlying()*/) {
            util.render(stack);
            /*// TODO not a clue if this will work but oh well - Loqor
            stack.push();
            stack.scale(0.9f, 0.9f, 0.9f);
            util.renderVortex(stack);
            stack.pop();*/
        }
        botiProvider.method_22993();
        stack.method_22909();

        if (!tardis.getExterior().getCategory().equals(CategoryRegistry.GEOMETRIC)) {
            stack.method_22903();
            stack.method_22907(class_7833.field_40716.rotationDegrees(180));
            stack.method_22905(scale.x, scale.y, scale.z);

            // TODO: use DoorRenderer/ClientLightUtil instead.
            frame.renderWithAnimations(tardis, door, frame.getPart(), stack, botiProvider.getBuffer(AITRenderLayers.getBotiInterior(variant.texture())), light, class_4608.field_21444, 1, 1F, 1.0F, 1.0F, tickDelta);
            //((DoorModel) frame).render(stack, botiProvider.getBuffer(AITRenderLayers.getBotiInterior(variant.texture())), light, OverlayTexture.DEFAULT_UV, 1, 1F, 1.0F, 1.0F);
            botiProvider.method_22993();
            stack.method_22909();

            stack.method_22903();
            stack.method_22907(class_7833.field_40716.rotationDegrees(180));
            stack.method_22905(scale.x, scale.y, scale.z);
            if (variant.emission() != null) {
                float u = 1;
                float t = 1;
                float s = 1;

                if ((stats.getName() != null && "partytardis".equalsIgnoreCase(stats.getName()) || (!tardis.extra().getInsertedDisc().method_7960()))) {
                    final float[] rgb = ClientTardisUtil.getPartyColors();

                    u = rgb[0];
                    t = rgb[1];
                    s = rgb[2];
                }

                boolean power = tardis.fuel().hasPower();
                boolean alarm = tardis.alarm().isEnabled();

                float red = power ? s : 0;
                float green = power ? alarm ? 0.3f : t : 0;
                float blue = power ? alarm ? 0.3f : u:  0;

                frame.renderWithAnimations(tardis, door, frame.getPart(), stack, botiProvider.getBuffer((DependencyChecker.hasIris() ? AITRenderLayers.tardisEmissiveCullZOffset(variant.emission(), true) : AITRenderLayers.method_23028(variant.emission()))), 0xf000f0, class_4608.field_21444, red, green, blue, 1.0F, tickDelta);
                botiProvider.method_22993();
            }
            stack.method_22909();
        }

        class_310.method_1551().method_1522().method_1235(true);

        BOTI.copyColor(BOTI_HANDLER.afbo, class_310.method_1551().method_1522());

        GL11.glDisable(GL11.GL_STENCIL_TEST);

        RenderSystem.depthMask(true);

        stack.method_22909();
    }
}
