package dev.amble.ait.client.boti;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class TardisExteriorBOTI extends BOTI {
    public void renderExteriorBoti(ExteriorBlockEntity exterior, ClientExteriorVariantSchema variant, class_4587 stack, class_2960 frameTex, ExteriorModel frame, class_630 mask, int light) {
        if (class_310.method_1551().field_1687 == null
                || class_310.method_1551().field_1724 == null) return;

        if (!exterior.isLinked())
            return;

        ClientTardis tardis = exterior.tardis().get().asClient();;

        stack.method_22903();

        class_310.method_1551().method_1522().method_1240();

        BOTI_HANDLER.setupFramebuffer();

        class_243 skyColor = class_310.method_1551().field_1687.method_23777(class_310.method_1551().field_1724.method_19538(), class_310.method_1551().method_1488());
        if (AITModClient.CONFIG.greenScreenBOTI)
            BOTI.setFramebufferColor(BOTI_HANDLER.afbo, 0, 1, 0, 1);
        else
            BOTI.setFramebufferColor(BOTI_HANDLER.afbo, (float) skyColor.field_1352, (float) skyColor.field_1351, (float) skyColor.field_1350, 1);

        BOTI.copyFramebuffer(class_310.method_1551().method_1522(), BOTI_HANDLER.afbo);

        class_4597.class_4598 botiProvider = AIT_BUF_BUILDER_STORAGE.getBotiVertexConsumer();

        GL11.glEnable(GL11.GL_STENCIL_TEST);
        GL11.glStencilMask(0xFF);
        GL11.glClear(GL11.GL_STENCIL_BUFFER_BIT);
        GL11.glStencilFunc(GL11.GL_ALWAYS, 1, 0xFF);
        GL11.glStencilOp(GL11.GL_KEEP, GL11.GL_KEEP, GL11.GL_REPLACE);

        RenderSystem.depthMask(true);
        stack.method_22903();
        StatsHandler stats = tardis.stats();
        String name = stats.getName();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));
        Vector3f scale = tardis.travel().getScale();
        if (name.equalsIgnoreCase("grumm") || name.equalsIgnoreCase("dinnerbone")) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-90f));
            stack.method_46416(0, scale.y() + 0.25f, scale.z() - 1.7f);
        }
        ExteriorVariantSchema parent = variant.parent();
        stack.method_22905((float) parent.portalWidth() * scale.x(),
                (float) parent.portalHeight() * scale.y(), scale.z());
        class_243 vec = parent.adjustPortalPos(new class_243(0, -0.4675f, 0), (byte) 0);
        stack.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        class_1921 whichOne = AITModClient.CONFIG.greenScreenBOTI ?
                class_1921.method_49047() : class_1921.method_34571();
        float[] colorsForGreenScreen = AITModClient.CONFIG.greenScreenBOTI ? new float[]{0, 1, 0, 1} : new float[] {(float) skyColor.field_1352, (float) skyColor.field_1351, (float) skyColor.field_1350};
        mask.method_22699(stack, botiProvider.getBuffer(whichOne), light, class_4608.field_21444, colorsForGreenScreen[0], colorsForGreenScreen[1], colorsForGreenScreen[2], 1);
        botiProvider.method_22993();
        stack.method_22909();

        copyDepth(BOTI_HANDLER.afbo, class_310.method_1551().method_1522());

        BOTI_HANDLER.afbo.method_1235(false);
        GL11.glClear(GL11.GL_DEPTH_BUFFER_BIT);

        GL11.glStencilMask(0x00);
        GL11.glStencilFunc(GL11.GL_EQUAL, 1, 0xFF);

        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));
        if (name.equalsIgnoreCase("grumm") || name.equalsIgnoreCase("dinnerbone")) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-90f));
            stack.method_46416(0, scale.y + 0.25f, scale.z -1.7f);
        }
        stack.method_22905(scale.x(), scale.y(), scale.z());

        frame.renderDoors(tardis, exterior, frame.getPart(), stack, botiProvider.getBuffer(AITRenderLayers.getBotiInterior(variant.texture())), light, class_4608.field_21444, 1, 1F, 1.0F, 1.0F, true);
        botiProvider.method_22993();
        stack.method_22909();

        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));
        if (name.equalsIgnoreCase("grumm") || name.equalsIgnoreCase("dinnerbone")) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-90f));
            stack.method_46416(0, scale.y() + 0.25f, scale.z() -1.7f);
        }
        stack.method_22905(scale.x(), scale.y(), scale.z());

        if (variant != ClientExteriorVariantRegistry.CORAL_GROWTH) {
            BiomeHandler handler = exterior.tardis().get().handler(TardisComponent.Id.BIOME);
            class_2960 biomeTexture = handler.getBiomeKey().get(variant.overrides());
            if (biomeTexture != null)
                frame.renderDoors(tardis, exterior, frame.getPart(), stack,
                        botiProvider.getBuffer(AITRenderLayers.method_23689(biomeTexture)),
                        light, class_4608.field_21444, 1, 1F, 1.0F, 1.0F, true);
        }
        botiProvider.method_22993();
        stack.method_22909();

        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180));
        if (name.equalsIgnoreCase("grumm") || name.equalsIgnoreCase("dinnerbone")) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-90f));
            stack.method_46416(0, scale.y + 0.25f, scale.z -1.7f);
        }
        stack.method_22905(scale.x(), scale.y(), scale.z());
        if (variant.emission() != null) {
            float u;
            float t;
            float s;

            if ((stats.getName() != null && "partytardis".equals(stats.getName().toLowerCase()) || (!exterior.tardis().get().extra().getInsertedDisc().method_7960()))) {
                int m = 25;
                int n = class_310.method_1551().field_1724.field_6012 / m + class_310.method_1551().field_1724.method_5628();
                int o = class_1767.values().length;
                int p = n % o;
                int q = (n + 1) % o;
                float r = ((float) (class_310.method_1551().field_1724.field_6012 % m)) / m;
                float[] fs = class_1472.method_6634(class_1767.method_7791(p));
                float[] gs = class_1472.method_6634(class_1767.method_7791(q));
                s = fs[0] * (1f - r) + gs[0] * r;
                t = fs[1] * (1f - r) + gs[1] * r;
                u = fs[2] * (1f - r) + gs[2] * r;
            } else {
                float[] hs = new float[]{1.0f, 1.0f, 1.0f};
                s = hs[0];
                t = hs[1];
                u = hs[2];
            }

            boolean power = tardis.fuel().hasPower();
            boolean alarms = tardis.alarm().isEnabled();

            float red = power ? s : alarms ? 0.3f : 0;
            float green = power ? alarms ? 0.3f : t : 0;
            float blue = power ? alarms ? 0.3f : u : 0;

            frame.renderDoors(tardis, exterior, frame.getPart(), stack, botiProvider.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(variant.emission(), true)), 0xf000f0,
                    class_4608.field_21444, red, green, blue, 1, true);
            botiProvider.method_22993();
        }
        stack.method_22909();

        class_310.method_1551().method_1522().method_1235(true);

        BOTI.copyColor(BOTI_HANDLER.afbo, class_310.method_1551().method_1522());

        GL11.glDisable(GL11.GL_STENCIL_TEST);

        stack.method_22909();
    }
}
