package dev.amble.ait.client.commands;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

import java.util.List;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import dev.amble.lib.api.Identifiable;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import dev.amble.ait.AITMod;
import dev.amble.ait.registry.impl.door.ClientDoorRegistry;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class DebugCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(literal(AITMod.MOD_ID + "-client").then(literal("debug").executes(context -> {

            context.getSource().sendFeedback(class_2561.method_43470("Door registry: " + stringify(DoorRegistry.getInstance().toList())));
            context.getSource().sendFeedback(class_2561.method_43470("Client Door registry: " + stringify(ClientDoorRegistry.getInstance().toList())));
            context.getSource().sendFeedback(class_2561.method_43470("Exterior registry: " + stringify(ExteriorVariantRegistry.getInstance().toList())));
            context.getSource().sendFeedback(class_2561.method_43470("Client Exterior registry: " + stringify(ClientExteriorVariantRegistry.getInstance().toList())));
            DoorRegistry.getInstance().toList();
            return Command.SINGLE_SUCCESS;
        })));
    }

    public static String stringify(List<? extends Identifiable> list) {
        return list.stream().map(idlike -> idlike == null ? null : idlike.id().toString()).toList().toString();
    }
}
