package dev.amble.ait.client.config;

import dev.amble.ait.AITMod;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.*;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.ValueFormatters;
import dev.isxander.yacl3.platform.YACLPlatform;
import net.minecraft.class_2561;

public class AITClientConfig {

    public static final String CATEGORY = "client";

    public static final ConfigClassHandler<AITClientConfig> INSTANCE = ConfigClassHandler.createBuilder(AITClientConfig.class)
            .id(YACLPlatform.rl(AITMod.MOD_ID, "client"))
            .serializer(config -> GsonConfigSerializerBuilder.create(config)
                    .setPath(YACLPlatform.getConfigDir().resolve("ait-client.json5"))
                    .setJson5(true)
                    .build())
            .build();

    @AutoGen(category = CATEGORY)
    @CustomFormat(ValueFormatters.PercentFormatter.class)
    @FloatSlider(min = 0f, max = 1f, step = 0.05f)
    @SerialEntry public float interiorHumVolume = 0.5f;

    @AutoGen(category = CATEGORY)
    @CustomFormat(ValueFormatters.PercentFormatter.class)
    @FloatSlider(min = 0f, max = 1f, step = 0.01f)
    @SerialEntry public float engineLoopVolume = 0.35f;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean customMenu = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean showExperimentalWarning = false;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean environmentProjector = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean enableTardisBOTI = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean greenScreenBOTI = false;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean allowPortalsBoti = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean showControlHitboxes = false;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean showConsoleMonitorText = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean showCRTMonitorText = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean renderDematParticles = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean powerOffDarkness = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean animateConsole = true;

    @AutoGen(category = CATEGORY)
    @Boolean(formatter = Boolean.Formatter.YES_NO, colored = true)
    @SerialEntry public boolean animateDoors = true;

    @AutoGen(category = CATEGORY)
    @IntField(min = 0)
    @CustomDescription(value = "The levenshtein distance allows for typos when using handles. Distances lower to 0 are stricter while higher values like 5 are more lenient.")
    @CustomImage(value = "textures/yacl3/server/levenshtein.webp", width = 1909, height = 349)
    @SerialEntry public int handlesLevenshteinDistance = 2;

    @AutoGen(category = CATEGORY)
    @EnumCycler
    @SerialEntry public TemperatureType temperatureType = TemperatureType.CELSIUS;

    public enum TemperatureType implements NameableEnum {
        CELSIUS,
        FAHRENHEIT,
        KELVIN;

        private final String key;

        TemperatureType() {
            this.key = "yacl3.config.ait:client.temperatureType.unit." + this.toString().toLowerCase();
        }

        @Override
        public class_2561 getDisplayName() {
            return class_2561.method_43471(key);
        }
    }
}
