package dev.amble.ait.client.models.doors;

import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.handler.DoorHandler;

public class BookshelfDoorModel extends DoorModel {
    private final class_630 bookshelf;

    public BookshelfDoorModel(class_630 root) {
        this.bookshelf = root.method_32086("bookshelf");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 bookshelf = modelPartData.method_32117("bookshelf",
                class_5606.method_32108().method_32101(51, 14)
                        .method_32098(-12.5938F, -21.5354F, 7.5385F, 2.0F, 42.0F, 2.0F, new class_5605(0.0F)).method_32101(14, 14)
                        .method_32098(9.4062F, -21.5354F, 7.5385F, 2.0F, 42.0F, 2.0F, new class_5605(0.0F)).method_32101(14, 73)
                        .method_32098(-10.5938F, 18.4646F, 7.5385F, 20.0F, 2.0F, 2.0F, new class_5605(0.0F)).method_32101(0, 78)
                        .method_32098(-10.5938F, -19.5354F, 7.5385F, 20.0F, 38.0F, 0.0F, new class_5605(0.05F)).method_32101(72, 57)
                        .method_32098(-10.5938F, -21.5354F, 7.5385F, 20.0F, 2.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32091(-0.5938F, 3.5354F, 15.4615F, 0.0F, 3.1416F, 0.0F));

        bookshelf.method_32117("left_door", class_5606.method_32108().method_32101(66, 81).method_32098(-9.0F, -38.0F, -1.0F, 10.0F, 38.0F,
                2.0F, new class_5605(0.0F)), class_5603.method_32090(8.4062F, 18.4646F, 8.5385F));

        bookshelf.method_32117("right_door", class_5606.method_32108().method_32101(41, 81).method_32098(-1.0F, -38.0F, -1.0F, 10.0F, 38.0F,
                2.0F, new class_5605(0.0F)), class_5603.method_32090(-9.5938F, 18.4646F, 8.5385F));
        return class_5607.method_32110(modelData, 256, 256);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
            float green, float blue, float alpha) {
        bookshelf.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, AbstractLinkableBlockEntity doorEntity, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, float tickDelta) {
        DoorHandler door = tardis.door();

        if (!AITModClient.CONFIG.animateDoors) {
            this.bookshelf.method_32086("left_door").field_3675 = (door.isLeftOpen() || door.isOpen()) ? 4.75F : 0.0F;
            this.bookshelf.method_32086("right_door").field_3675 = (door.isRightOpen() || door.areBothOpen()) ? -4.75F : 0.0F;
        } else {
            float maxRot = 90f;
            this.bookshelf.method_32086("left_door").field_3675 = (float) Math.toRadians(maxRot*door.getRightRot());
            this.bookshelf.method_32086("right_door").field_3675 = (float) -Math.toRadians(maxRot*door.getLeftRot());
        }

        matrices.method_22903();
        matrices.method_22905(1F, 1F, 1F);
        matrices.method_22904(0, -1.5, 0);

        super.renderWithAnimations(tardis, doorEntity, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, tickDelta);
        matrices.method_22909();
    }

    @Override
    public class_630 method_32008() {
        return bookshelf;
    }
}
