package dev.amble.ait.client.models.exteriors;

import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;

public class BoothExteriorModel extends SimpleExteriorModel {

    private final class_630 k2;

    public BoothExteriorModel(class_630 root) {
        this.k2 = root.method_32086("k2");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 k2 = modelPartData.method_32117("k2",
                class_5606.method_32108().method_32101(0, 0).method_32098(-9.5F, -2.0F, -9.5F, 18.0F, 2.0F, 18.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.5F, 24.0F, 0.5F));

        class_5610 Posts = k2.method_32117("Posts", class_5606.method_32108().method_32101(58, 103).method_32098(-9.0F, -36.0F, -9.0F,
                2.0F, 34.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 cube_r1 = Posts.method_32117("cube_r1", class_5606.method_32108().method_32101(58, 103).method_32098(-8.0F, -36.0F,
                -9.0F, 2.0F, 34.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r2 = Posts.method_32117("cube_r2", class_5606.method_32108().method_32101(58, 103).method_32098(-8.0F, -36.0F,
                -8.0F, 2.0F, 34.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r3 = Posts.method_32117("cube_r3", class_5606.method_32108().method_32101(58, 103).method_32098(-9.0F, -36.0F,
                -8.0F, 2.0F, 34.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 Roof = k2.method_32117("Roof",
                class_5606.method_32108().method_32101(52, 49)
                        .method_32098(-9.0F, -37.0F, -9.0F, 17.0F, 2.0F, 17.0F, new class_5605(0.0F)).method_32101(52, 27)
                        .method_32098(-9.0F, -37.0F, -9.0F, 17.0F, 2.0F, 17.0F, new class_5605(0.25F)).method_32101(0, 21)
                        .method_32098(-9.0F, -45.0F, -9.0F, 17.0F, 5.0F, 17.0F, new class_5605(0.0F)).method_32101(0, 44)
                        .method_32098(-9.0F, -45.0F, -9.0F, 17.0F, 4.0F, 17.0F, new class_5605(0.4F)).method_32101(57, 5)
                        .method_32098(-8.5F, -40.25F, -8.5F, 16.0F, 4.0F, 16.0F, new class_5605(0.0F)).method_32101(0, 66)
                        .method_32098(-8.5F, -40.75F, -8.5F, 16.0F, 1.0F, 16.0F, new class_5605(0.3F)),
                class_5603.method_32090(0.0F, -1.0F, 0.0F));

        class_5610 Walls = k2.method_32117("Walls", class_5606.method_32108(), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 cube_r4 = Walls.method_32117("cube_r4",
                class_5606.method_32108().method_32101(94, 104)
                        .method_32098(-5.5F, -35.5F, -8.75F, 12.0F, 33.0F, 0.0F, new class_5605(0.01F)).method_32101(0, 84)
                        .method_32098(-6.0F, -36.0F, -9.25F, 13.0F, 34.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r5 = Walls.method_32117("cube_r5",
                class_5606.method_32108().method_32101(94, 104)
                        .method_32098(-6.5F, -35.5F, -7.75F, 12.0F, 33.0F, 0.0F, new class_5605(0.01F)).method_32101(0, 84)
                        .method_32098(-7.0F, -36.0F, -8.25F, 13.0F, 34.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 cube_r6 = Walls.method_32117("cube_r6",
                class_5606.method_32108().method_32101(94, 69).method_32098(-6.0F, -36.0F, 8.0F, 13.0F, 34.0F, 0.0F, new class_5605(0.0F))
                        .method_32101(29, 84).method_32098(-6.0F, -36.0F, -8.25F, 13.0F, 34.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 Door = k2.method_32117("Door",
                class_5606.method_32108().method_32101(65, 69)
                        .method_32098(0.0F, -20.0F, -0.25F, 13.0F, 34.0F, 1.0F, new class_5605(0.0F)).method_32101(0, 4)
                        .method_32098(11.5F, -5.0F, -0.85F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F)).method_32101(0, 0)
                        .method_32098(11.0F, -5.5F, -0.35F, 2.0F, 3.0F, 0.0F, new class_5605(0.0F)).method_32101(94, 104)
                        .method_32098(0.5F, -19.5F, 0.25F, 12.0F, 33.0F, 0.0F, new class_5605(0.01F)),
                class_5603.method_32090(-7.0F, -16.0F, -9.0F));
        return class_5607.method_32110(modelData, 256, 256);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
            float green, float blue, float alpha) {
        k2.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_22905(1f, 1f, 1f);
        matrices.method_46416(0, -1.5f, 0);
        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        if (!AITModClient.CONFIG.animateDoors)
            this.k2.method_32086("Door").field_3675 = tardis.door().isOpen() ? 1.575F : 0.0F;
        else {
            float maxRot = 90f;
            this.k2.method_32086("Door").field_3675 = (float) Math.toRadians(maxRot * tardis.door().getLeftRot());
        }

        if (isBOTI) {
            matrices.method_22903();
            matrices.method_22905(1f, 1f, 1f);
            matrices.method_46416(0, -1.5f, 0);
            this.k2.method_32086("Door").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            matrices.method_22909();
        }
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (falling.tardis().isEmpty())
            return;

        matrices.method_22903();
        if (!AITModClient.CONFIG.animateDoors)
            this.k2.method_32086("Door").field_3675 = falling.tardis().get().door().isOpen() ? 1.575F : 0.0F;
        else {
            float maxRot = 90f;
            this.k2.method_32086("Door").field_3675 = (float) Math.toRadians(maxRot * falling.tardis().get().door().getLeftRot());
        }
        matrices.method_22905(1f, 1f, 1f);
        matrices.method_46416(0, -1.5f, 0);

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public class_630 method_32008() {
        return k2;
    }
}
