package dev.amble.ait.client.models.exteriors;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.DoorHandler;

public class CapsuleExteriorModel extends SimpleExteriorModel {
    private final class_630 body;

    public CapsuleExteriorModel(class_630 root) {
        super(class_1921::method_23578);
        this.body = root.method_32086("body");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 body = modelPartData.method_32117("body", class_5606.method_32108(),
                class_5603.method_32090(0.0F, 3.0F, 0.0F));

        class_5610 top = body.method_32117("top",
                class_5606.method_32108().method_32101(45, 92)
                        .method_32098(-4.9706F, -42.0F, -12.0F, 9.9411F, 8.0F, 24.0F, new class_5605(0.001F)).method_32101(73, 1)
                        .method_32098(-12.0F, -42.1F, -12.0F, 24.0F, 0.0F, 24.0F, new class_5605(0.0F)).method_32101(0, 25)
                        .method_32098(-12.0F, -33.89F, -12.0F, 24.0F, 0.0F, 24.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, 21.0F, 0.0F));

        class_5610 octagon_r1 = top
                .method_32117(
                        "octagon_r1", class_5606.method_32108().method_32101(73, 26).method_32098(-4.9706F, -42.0F, -12.0F, 9.9411F,
                                8.0F, 24.0F, new class_5605(0.001F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 octagon_r2 = top
                .method_32117(
                        "octagon_r2", class_5606.method_32108().method_32101(73, 59).method_32098(-4.9706F, -42.0F, -12.0F, 9.9411F,
                                8.0F, 24.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -0.7854F, 0.0F));

        class_5610 octagon_r3 = top
                .method_32117(
                        "octagon_r3", class_5606.method_32108().method_32101(0, 75).method_32098(-22.9706F, -42.0F, -12.0F, 9.9411F,
                                8.0F, 24.0F, new class_5605(0.0F)),
                        class_5603.method_32091(12.7279F, 0.0F, -12.7279F, 0.0F, 0.7854F, 0.0F));

        class_5610 middle = body.method_32117("middle", class_5606.method_32108().method_32101(26, 135).method_32098(-4.7635F, -34.0F,
                9.5F, 9.5269F, 32.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 21.0F, 0.0F));

        class_5610 octagon_r4 = middle
                .method_32117(
                        "octagon_r4", class_5606.method_32108().method_32101(120, 128).method_32098(-4.7635F, -34.0F, 9.5F, 9.5269F,
                                32.0F, 2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -0.7854F, 0.0F));

        class_5610 octagon_r5 = middle
                .method_32117(
                        "octagon_r5", class_5606.method_32108().method_32101(50, 135).method_32098(-2.2365F, -34.0F, 9.5F, 7.0F, 32.0F,
                                2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, -3.1416F, -0.7854F, 3.1416F));

        class_5610 octagon_r6 = middle
                .method_32117(
                        "octagon_r6", class_5606.method_32108().method_32101(95, 128).method_32098(-4.7635F, -34.0F, 9.5F, 9.5269F,
                                32.0F, 2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 octagon_r7 = middle
                .method_32117(
                        "octagon_r7", class_5606.method_32108().method_32101(70, 128).method_32098(-4.7635F, -34.0F, 9.5F, 9.5269F,
                                32.0F, 2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 octagon_r8 = middle
                .method_32117(
                        "octagon_r8", class_5606.method_32108().method_32101(144, 128).method_32098(-4.7635F, -34.0F, 9.5F, 7.0F, 32.0F,
                                2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, -3.1416F, 0.7854F, 3.1416F));

        class_5610 octagon_r9 = middle
                .method_32117(
                        "octagon_r9", class_5606.method_32108().method_32101(1, 135).method_32098(-4.7635F, -34.0F, 9.5F, 9.5269F,
                                32.0F, 2.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 0.7854F, 0.0F));

        class_5610 bottom = body.method_32117("bottom",
                class_5606.method_32108().method_32101(118, 68)
                        .method_32098(-4.9706F, -2.0F, -12.0F, 9.9411F, 2.0F, 24.0F, new class_5605(0.001F)).method_32101(0, 50)
                        .method_32098(-12.0F, 0.01F, -12.0F, 24.0F, 0.0F, 24.0F, new class_5605(0.0F)).method_32101(0, 0)
                        .method_32098(-12.0F, -2.1F, -12.0F, 24.0F, 0.0F, 24.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, 21.0F, 0.0F));

        class_5610 octagon_r10 = bottom
                .method_32117(
                        "octagon_r10", class_5606.method_32108().method_32101(90, 101).method_32098(-4.9706F, -2.0F, -12.0F, 9.9411F,
                                2.0F, 24.0F, new class_5605(0.001F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 octagon_r11 = bottom
                .method_32117(
                        "octagon_r11", class_5606.method_32108().method_32101(118, 35).method_32098(-4.9706F, -2.0F, -12.0F, 9.9411F,
                                2.0F, 24.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 0.7854F, 0.0F));

        class_5610 octagon_r12 = bottom
                .method_32117(
                        "octagon_r12", class_5606.method_32108().method_32101(0, 108).method_32098(-4.9706F, -2.0F, -12.0F, 9.9411F,
                                2.0F, 24.0F, new class_5605(0.0F)),
                        class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -0.7854F, 0.0F));

        class_5610 doors = body.method_32117("doors", class_5606.method_32108(),
                class_5603.method_32090(0.0F, -2.0F, 0.0F));

        class_5610 right_door = doors.method_32117("right_door", class_5606.method_32108().method_32101(162, 162).method_32098(0.4706F,
                -11.0F, -0.5F, 6.0F, 32.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(-6.5F, 0.0F, -8.5F));

        class_5610 left_door = doors.method_32117("left_door", class_5606.method_32108().method_32101(161, 95).method_32098(-6.5294F,
                -11.0F, -0.5F, 6.0F, 32.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(6.5F, 0.0F, -8.5F));
        return class_5607.method_32110(modelData, 256, 256);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (falling.tardis().isEmpty())
            return;

        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        if (!AITModClient.CONFIG.animateDoors) {
            DoorHandler handler = falling.tardis().get().door();

            this.body.method_32086("doors").method_32086("left_door").field_3675 = (handler.isLeftOpen() || handler.isOpen()) ? -5F : 0.0F;
            this.body.method_32086("doors").method_32086("right_door").field_3675 = (handler.isRightOpen() || handler.areBothOpen())
                    ? 5F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.body.method_32086("doors").method_32086("left_door").field_3675 = (float) Math.toRadians(maxRot * falling.tardis().get().door().getLeftRot());
            this.body.method_32086("doors").method_32086("right_door").field_3675 = -(float) Math.toRadians(maxRot * falling.tardis().get().door().getRightRot());
        }

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);

        matrices.method_22909();
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        if (!AITModClient.CONFIG.animateDoors) {
            DoorHandler handler = tardis.door();

            this.body.method_32086("doors").method_32086("left_door").field_3675 = (handler.isLeftOpen() || handler.isOpen()) ? -5F : 0.0F;
            this.body.method_32086("doors").method_32086("right_door").field_3675 = (handler.isRightOpen() || handler.areBothOpen())
                    ? 5F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.body.method_32086("doors").method_32086("left_door").field_3675 = (float) Math.toRadians(maxRot * tardis.door().getLeftRot());
            this.body.method_32086("doors").method_32086("right_door").field_3675 = -(float) Math.toRadians(maxRot * tardis.door().getRightRot());
        }

        if (isBOTI) {
            matrices.method_22903();
            matrices.method_46416(0, -1.32f, 0);
            this.body.method_32086("doors").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            matrices.method_22909();
        }
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
            float green, float blue, float alpha) {
        this.body.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public class_630 method_32008() {
        return this.body;
    }
}
