package dev.amble.ait.client.models.exteriors;

import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;

public class PlinthExteriorModel extends SimpleExteriorModel {
    private final class_630 plinth;

    public PlinthExteriorModel(class_630 root) {
        this.plinth = root.method_32086("plinth");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 plinth = modelPartData.method_32117("plinth", class_5606.method_32108(),
                class_5603.method_32090(0.0F, 24.0F, 0.0F));

        class_5610 door = plinth.method_32117("door", class_5606.method_32108().method_32101(72, 61).method_32098(-12.0F, -42.0F, 0.0F,
                12.0F, 42.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(6.0F, -3.0F, -8.0F));

        class_5610 body = plinth.method_32117("body",
                class_5606.method_32108().method_32101(0, 0).method_32098(6.0F, -45.0F, -8.0F, 2.0F, 42.0F, 16.0F, new class_5605(0.0F))
                        .method_32101(0, 58).method_32098(-9.0F, -3.0F, -9.0F, 18.0F, 3.0F, 18.0F, new class_5605(0.0F)).method_32101(54, 40)
                        .method_32098(-9.0F, -48.0F, -9.0F, 18.0F, 3.0F, 18.0F, new class_5605(0.0F)).method_32101(0, 79)
                        .method_32098(-6.0F, -45.0F, 6.0F, 12.0F, 42.0F, 2.0F, new class_5605(0.0F)).method_32101(36, 0)
                        .method_32098(-8.0F, -45.0F, -8.0F, 2.0F, 42.0F, 16.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
            float green, float blue, float alpha) {
        plinth.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        if (!AITModClient.CONFIG.animateDoors)
            plinth.method_32086("door").field_3675 = falling.tardis().get().door().isOpen() ? -1.75f : 0f;
        else {
            float maxRot = 90f;
            plinth.method_32086("door").field_3675 = (float) Math.toRadians(maxRot*falling.tardis().get().door().getLeftRot());
        }

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);

        matrices.method_22909();
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        if (!AITModClient.CONFIG.animateDoors)
            plinth.method_32086("door").field_3675 = tardis.door().isOpen() ? -1.75f : 0f;
        else {
            float maxRot = 90f;
            plinth.method_32086("door").field_3675 = -(float) Math.toRadians(maxRot*tardis.door().getLeftRot());
        }

        if (isBOTI) {
            matrices.method_22903();
            matrices.method_46416(0, -1.5f, 0);
            plinth.method_32086("door").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            matrices.method_22909();
        }
    }

    @Override
    public class_630 method_32008() {
        return plinth;
    }
}
