package dev.amble.ait.client.models.exteriors;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.DoorHandler;

public class PoliceBoxModel extends SimpleExteriorModel {
    private final class_630 TARDIS;

    public PoliceBoxModel(class_630 root) {
        super(class_1921::method_23578);
        this.TARDIS = root.method_32086("TARDIS");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 TARDIS = modelPartData.method_32117("TARDIS", class_5606.method_32108().method_32101(0, 0).method_32098(-19.0F, -4.0F,
                -19.0F, 38.0F, 4.0F, 38.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 24.0F, 0.0F));

        class_5610 Posts = TARDIS.method_32117("Posts", class_5606.method_32108().method_32101(46, 223).method_32098(-18.0F, -66.0F,
                -18.0F, 4.0F, 62.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 cube_r1 = Posts.method_32117("cube_r1", class_5606.method_32108().method_32101(29, 198).method_32098(-18.0F, -66.0F,
                -18.0F, 4.0F, 62.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r2 = Posts.method_32117("cube_r2", class_5606.method_32108().method_32101(210, 177).method_32098(-18.0F, -66.0F,
                -18.0F, 4.0F, 62.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r3 = Posts.method_32117("cube_r3", class_5606.method_32108().method_32101(218, 41).method_32098(-18.0F, -66.0F,
                -18.0F, 4.0F, 62.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 Doors = TARDIS.method_32117("Doors", class_5606.method_32108(),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 right_door = Doors.method_32117("right_door",
                class_5606.method_32108().method_32101(181, 177)
                        .method_32098(0.5F, -29.5F, -0.5F, 13.0F, 55.0F, 1.0F, new class_5605(0.0F)).method_32101(0, 198)
                        .method_32098(0.5F, -29.5F, -1.0F, 14.0F, 55.0F, 0.0F, new class_5605(0.0F)).method_32101(0, 10)
                        .method_32098(9.5F, -9.5F, -1.5F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F)).method_32101(5, 51)
                        .method_32098(2.5F, -9.5F, -1.5F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32090(-13.5F, -29.5F, -15.5F));

        class_5610 left_door = Doors.method_32117("left_door",
                class_5606.method_32108().method_32101(189, 41)
                        .method_32098(-13.5F, -29.5F, -0.5F, 13.0F, 55.0F, 1.0F, new class_5605(0.0F)).method_32101(0, 0)
                        .method_32098(-12.5F, -10.5F, -1.5F, 1.0F, 4.0F, 1.0F, new class_5605(0.0F)).method_32101(0, 51)
                        .method_32098(-12.5F, -4.5F, -1.5F, 1.0F, 4.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32090(13.5F, -29.5F, -15.5F));

        class_5610 Walls = TARDIS.method_32117("Walls",
                class_5606.method_32108().method_32101(129, 15)
                        .method_32098(-16.0F, -60.0F, -14.0F, 1.0F, 56.0F, 28.0F, new class_5605(0.0F)).method_32101(59, 142)
                        .method_32098(-16.5F, -60.0F, -14.0F, 0.0F, 56.0F, 28.0F, new class_5605(0.0F)).method_32101(63, 227)
                        .method_32098(-14.0F, -60.0F, -16.0F, 1.0F, 56.0F, 1.0F, new class_5605(0.0F)).method_32101(116, 170)
                        .method_32098(13.0F, -60.0F, -16.0F, 1.0F, 56.0F, 1.0F, new class_5605(0.0F)).method_32101(115, 0)
                        .method_32098(-13.0F, -60.0F, -16.0F, 26.0F, 1.0F, 1.0F, new class_5605(0.0F)).method_32101(59, 113)
                        .method_32098(13.0F, -60.0F, -16.5F, 1.0F, 56.0F, 0.0F, new class_5605(0.0F)).method_32101(115, 3)
                        .method_32098(-13.0F, -60.0F, -16.5F, 26.0F, 1.0F, 0.0F, new class_5605(0.0F)).method_32101(62, 113)
                        .method_32098(-14.0F, -60.0F, -16.5F, 1.0F, 56.0F, 0.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 Wall_r1 = Walls.method_32117("Wall_r1",
                class_5606.method_32108().method_32101(160, 72)
                        .method_32098(-16.5F, -60.0F, -14.0F, 0.0F, 56.0F, 28.0F, new class_5605(0.0F)).method_32101(93, 85)
                        .method_32098(-16.0F, -60.0F, -14.0F, 1.0F, 56.0F, 28.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 Wall_r2 = Walls.method_32117("Wall_r2",
                class_5606.method_32108().method_32101(124, 142)
                        .method_32098(-16.75F, -60.0F, -14.0F, 0.0F, 56.0F, 28.0F, new class_5605(0.0F)).method_32101(0, 113)
                        .method_32098(-16.0F, -60.0F, -14.0F, 1.0F, 56.0F, 28.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 PCB = TARDIS.method_32117("PCB", class_5606.method_32108().method_32101(181, 167).method_32098(-17.0F, -64.0F, -19.0F,
                34.0F, 5.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -1.0F, 0.0F));

        class_5610 cube_r4 = PCB.method_32117("cube_r4", class_5606.method_32108().method_32101(153, 157).method_32098(-17.0F, -61.0F,
                -19.0F, 34.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r5 = PCB.method_32117("cube_r5", class_5606.method_32108().method_32101(160, 21).method_32098(-17.0F, -61.0F,
                -19.0F, 34.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r6 = PCB.method_32117("cube_r6", class_5606.method_32108().method_32101(160, 31).method_32098(-17.0F, -61.0F,
                -19.0F, 34.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 Roof = TARDIS.method_32117("Roof",
                class_5606.method_32108().method_32101(0, 43)
                        .method_32098(-16.0F, -68.0F, -16.0F, 32.0F, 4.0F, 32.0F, new class_5605(0.0F)).method_32101(0, 43)
                        .method_32098(-17.0F, -67.5F, -17.0F, 3.0F, 4.0F, 3.0F, new class_5605(0.05F)).method_32101(22, 7)
                        .method_32098(-17.0F, -67.5F, 14.0F, 3.0F, 4.0F, 3.0F, new class_5605(0.05F)).method_32101(0, 30)
                        .method_32098(14.0F, -67.5F, -17.0F, 3.0F, 4.0F, 3.0F, new class_5605(0.05F)).method_32101(17, 26)
                        .method_32098(14.0F, -67.5F, 14.0F, 3.0F, 4.0F, 3.0F, new class_5605(0.05F)).method_32101(0, 80)
                        .method_32098(-15.0F, -70.0F, -15.0F, 30.0F, 2.0F, 30.0F, new class_5605(0.0F)).method_32101(0, 0)
                        .method_32098(-3.0F, -72.0F, -3.0F, 6.0F, 3.0F, 6.0F, new class_5605(0.0F)).method_32101(0, 10)
                        .method_32098(-3.0F, -78.0F, -3.0F, 6.0F, 1.0F, 6.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, -1.0F, 0.0F));

        class_5610 cube_r7 = Roof.method_32117("cube_r7",
                class_5606.method_32108().method_32101(17, 18).method_32098(-2.0F, -70.75F, -2.0F, 4.0F, 3.0F, 4.0F, new class_5605(0.4F))
                        .method_32101(0, 18).method_32098(-2.0F, -73.75F, -2.0F, 4.0F, 7.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -5.25F, 0.0F, 0.0F, 0.7854F, 0.0F));

        class_5610 TARDIS_t = TARDIS.method_32117("TARDIS_t", class_5606.method_32108(),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 PCB_t = TARDIS_t.method_32117("PCB_t", class_5606.method_32108().method_32101(0, 394).method_32098(-16.0F, -64.0F,
                -19.0F, 32.0F, 5.0F, 4.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -1.0F, 0.0F));

        class_5610 cube_r8 = PCB_t.method_32117("cube_r8", class_5606.method_32108().method_32101(0, 404).method_32098(-16.0F, -61.0F,
                -19.0F, 32.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r9 = PCB_t.method_32117("cube_r9", class_5606.method_32108().method_32101(0, 414).method_32098(-16.0F, -61.0F,
                -19.0F, 32.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r10 = PCB_t.method_32117("cube_r10", class_5606.method_32108().method_32101(0, 424).method_32098(-16.0F, -61.0F,
                -19.0F, 32.0F, 5.0F, 4.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, -3.0F, 0.0F, 0.0F, -1.5708F, 0.0F));

        class_5610 Roof_t = TARDIS_t.method_32117("Roof_t",
                class_5606.method_32108().method_32101(0, 294)
                        .method_32098(-17.0F, -66.5F, -17.0F, 34.0F, 3.0F, 34.0F, new class_5605(0.0F)).method_32101(0, 332)
                        .method_32098(-15.0F, -68.25F, -15.0F, 30.0F, 2.0F, 30.0F, new class_5605(0.0F)).method_32101(0, 365)
                        .method_32098(-13.0F, -70.0F, -13.0F, 26.0F, 2.0F, 26.0F, new class_5605(0.0F)).method_32101(13, 65)
                        .method_32098(-17.5F, -65.75F, -17.5F, 3.0F, 1.0F, 3.0F, new class_5605(0.05F)).method_32101(0, 58)
                        .method_32098(14.5F, -65.75F, -17.5F, 3.0F, 1.0F, 3.0F, new class_5605(0.05F)).method_32101(13, 58)
                        .method_32098(-17.5F, -65.75F, 14.5F, 3.0F, 1.0F, 3.0F, new class_5605(0.05F)).method_32101(0, 65)
                        .method_32098(14.5F, -65.75F, 14.5F, 3.0F, 1.0F, 3.0F, new class_5605(0.05F)).method_32101(0, 295)
                        .method_32098(-3.0F, -71.0F, -3.0F, 6.0F, 1.0F, 6.0F, new class_5605(0.0F)).method_32101(0, 303)
                        .method_32098(-2.0F, -72.0F, -2.0F, 4.0F, 1.0F, 4.0F, new class_5605(0.0F)).method_32101(0, 309)
                        .method_32098(-2.0F, -78.0F, -2.0F, 4.0F, 2.0F, 4.0F, new class_5605(0.0F)).method_32101(9, 315)
                        .method_32098(0.0F, -76.5F, -3.0F, 0.0F, 5.0F, 6.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, -1.25F, 0.0F));

        class_5610 cube_r11 = Roof_t.method_32117("cube_r11",
                class_5606.method_32108().method_32101(9, 316).method_32098(-1.0F, -75.0F, -1.0F, 2.0F, 2.0F, 2.0F, new class_5605(0.5F))
                        .method_32101(0, 321).method_32098(-1.0F, -76.0F, -1.0F, 2.0F, 4.0F, 2.0F, new class_5605(0.2F)).method_32101(0, 316)
                        .method_32098(-1.0F, -79.0F, -1.0F, 2.0F, 2.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, -0.7854F, 0.0F));

        class_5610 cube_r12 = Roof_t.method_32117("cube_r12",
                class_5606.method_32108().method_32101(9, 315).method_32098(0.0F, -76.5F, -3.0F, 0.0F, 5.0F, 6.0F, new class_5605(0.0F)),
                class_5603.method_32091(0.0F, 0.0F, 0.0F, 0.0F, 1.5708F, 0.0F));
        return class_5607.method_32110(modelData, 512, 512);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
            float green, float blue, float alpha) {
        TARDIS.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public class_630 method_32008() {
        return TARDIS;
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_22905(0.63F, 0.63F, 0.63F);
        matrices.method_46416(0, -1.5f, 0);

        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!falling.isLinked())
            return;

        matrices.method_22903();
        matrices.method_22905(0.63F, 0.63F, 0.63F);
        matrices.method_46416(0, -1.5f, 0);

        DoorHandler door = falling.tardis().get().door();

        if (!AITModClient.CONFIG.animateDoors) {
            this.TARDIS.method_32086("Doors").method_32086("left_door").field_3675 = (door.isLeftOpen() || door.isOpen()) ? -5F : 0.0F;
            this.TARDIS.method_32086("Doors").method_32086("right_door").field_3675 = (door.isRightOpen() || door.areBothOpen())
                    ? 5F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.TARDIS.method_32086("Doors").method_32086("left_door").field_3675 =(float) Math.toRadians(maxRot*door.getLeftRot());
            this.TARDIS.method_32086("Doors").method_32086("right_door").field_3675 =(float) -Math.toRadians(maxRot*door.getRightRot());
        }

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        DoorHandler door = tardis.door();

        if (!AITModClient.CONFIG.animateDoors) {
            this.TARDIS.method_32086("Doors").method_32086("left_door").field_3675 = (door.isLeftOpen() || door.isOpen()) ? -5F : 0.0F;
            this.TARDIS.method_32086("Doors").method_32086("right_door").field_3675 = (door.isRightOpen() || door.areBothOpen())
                    ? 5F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.TARDIS.method_32086("Doors").method_32086("left_door").field_3675 =(float) Math.toRadians(maxRot*door.getLeftRot());
            this.TARDIS.method_32086("Doors").method_32086("right_door").field_3675 =(float) -Math.toRadians(maxRot*door.getRightRot());
        }

        if (isBOTI) {
            matrices.method_22903();
            matrices.method_22905(0.63F, 0.63F, 0.63F);
            matrices.method_22904(0, 0f, -0.01);
            this.TARDIS.method_32086("Doors").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            matrices.method_22909();
        }
    }
}
