package dev.amble.ait.client.models.exteriors;

import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.DoorHandler;

public class PresentExteriorModel extends SimpleExteriorModel {
    private final class_630 present;
    public PresentExteriorModel(class_630 root) {
        this.present = root.method_32086("present");
    }
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 present = modelPartData.method_32117("present", class_5606.method_32108().method_32101(0, 0).method_32098(-10.0F, -32.0F, -10.0F, 20.0F, 32.0F, 20.0F, new class_5605(0.0F))
        .method_32101(0, 52).method_32098(-10.0F, -38.6F, -10.0F, 20.0F, 6.0F, 20.0F, new class_5605(0.5F)), class_5603.method_32090(0.0F, 24.0F, 0.0F));

        class_5610 right_door = present.method_32117("right_door", class_5606.method_32108().method_32101(64, 78).method_32098(-10.0F, -16.0F, 0.0F, 10.0F, 32.0F, 0.0F, new class_5605(0.01F)), class_5603.method_32090(10.0F, -16.0F, -10.001F));

        class_5610 left_door = present.method_32117("left_door", class_5606.method_32108().method_32101(44, 78).method_32098(0.0F, -16.0F, 0.0F, 10.0F, 32.0F, 0.0F, new class_5605(0.01F)), class_5603.method_32090(-10.0F, -16.0F, -10.001F));

        class_5610 bow = present.method_32117("bow", class_5606.method_32108().method_32101(0, 78).method_32098(-11.0F, -12.0F, 0.0F, 22.0F, 13.0F, 0.0F, new class_5605(0.01F)), class_5603.method_32090(0.0F, -39.6F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        present.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (falling.tardis().isEmpty())
            return;

        matrices.method_22903();
        matrices.method_46416(0, -1.5f, 0);

        if (!AITModClient.CONFIG.animateDoors) {
            DoorHandler door = falling.tardis().get().door();

            this.present.method_32086("left_door").field_3675 = (door.isLeftOpen() || door.isOpen()) ? 8F : 0.0F;
            this.present.method_32086("right_door").field_3675 = (door.isRightOpen() || door.areBothOpen())
                    ? -8F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.present.method_32086("left_door").field_3675 = (float) Math.toRadians(falling.tardis().get().door().getLeftRot() * maxRot);
            this.present.method_32086("right_door").field_3675 = -(float) Math.toRadians(falling.tardis().get().door().getRightRot() * maxRot);
        }

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public class_630 method_32008() {
        return present;
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        if (!AITModClient.CONFIG.animateDoors) {
            DoorHandler door = tardis.door();

            this.present.method_32086("left_door").field_3675 = (door.isLeftOpen() || door.isOpen()) ? 8F : 0.0F;
            this.present.method_32086("right_door").field_3675 = (door.isRightOpen() || door.areBothOpen())
                    ? -8F
                    : 0.0F;
        } else {
            float maxRot = 90f;
            this.present.method_32086("left_door").field_3675 = (float) Math.toRadians(tardis.door().getLeftRot() * maxRot);
            this.present.method_32086("right_door").field_3675 = -(float) Math.toRadians(tardis.door().getRightRot() * maxRot);
        }

        if (isBOTI) {
            matrices.method_22903();
            matrices.method_46416(0, -1.5f, -3);
            this.present.method_32086("left_door").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            this.present.method_32086("right_door").method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
            matrices.method_22909();
        }
    }
}