package dev.amble.ait.client.models.exteriors.exclusive;

import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.exteriors.SimpleExteriorModel;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.handler.DoorHandler;

public class BlueBoxExteriorModel extends SimpleExteriorModel {
    private final class_630 box;
    private final class_630 base;
    private final class_630 left_door2;
    private final class_630 pulltoopen;
    private final class_630 phone;
    private final class_630 right_door2;

    public BlueBoxExteriorModel(class_630 root) {
        this.box = root.method_32086("box");
        this.base = this.box.method_32086("base");
        this.left_door2 = this.box.method_32086("left_door2");
        this.pulltoopen = this.left_door2.method_32086("pulltoopen");
        this.phone = this.pulltoopen.method_32086("phone");
        this.right_door2 = this.box.method_32086("right_door2");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 box = modelPartData.method_32117("box", class_5606.method_32108(), class_5603.method_32090(-6.0F, 24.0F, 0.0F));

        class_5610 base = box.method_32117("base", class_5606.method_32108().method_32101(0, 48).method_32098(-20.0F, -3.0F, -20.0F, 40.0F, 3.0F, 40.0F, new class_5605(0.0F))
        .method_32101(39, 39).method_32098(-18.0F, -71.0F, -21.0F, 36.0F, 5.0F, 3.0F, new class_5605(0.0F))
        .method_32101(115, 0).method_32098(-18.0F, -75.0F, -18.0F, 36.0F, 4.0F, 36.0F, new class_5605(0.0F))
        .method_32101(121, 48).method_32098(-16.0F, -76.0F, -16.0F, 32.0F, 1.0F, 32.0F, new class_5605(0.0F))
        .method_32101(62, 193).method_32098(-10.0F, -77.0F, -10.0F, 20.0F, 1.0F, 20.0F, new class_5605(0.0F))
        .method_32101(39, 91).method_32098(18.0F, -71.0F, -18.0F, 3.0F, 5.0F, 36.0F, new class_5605(0.0F))
        .method_32101(0, 91).method_32098(-21.0F, -71.0F, -18.0F, 3.0F, 5.0F, 36.0F, new class_5605(0.0F))
        .method_32101(156, 133).method_32098(-14.0F, -66.0F, -18.5F, 28.0F, 1.0F, 1.0F, new class_5605(0.0F))
        .method_32101(156, 133).method_32098(-14.0F, -66.0F, 17.5F, 28.0F, 1.0F, 1.0F, new class_5605(0.0F))
        .method_32101(36, 134).method_32098(17.5F, -66.0F, -14.0F, 1.0F, 1.0F, 28.0F, new class_5605(0.0F))
        .method_32101(0, 134).method_32098(-18.5F, -66.0F, -14.0F, 1.0F, 1.0F, 28.0F, new class_5605(0.0F))
        .method_32101(31, 164).method_32098(-18.0F, -65.0F, 0.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F))
        .method_32101(0, 164).method_32098(-18.0F, -65.0F, -14.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F))
        .method_32101(169, 213).method_32098(-18.5F, -65.0F, -0.5F, 1.0F, 62.0F, 1.0F, new class_5605(0.0F))
        .method_32101(159, 213).method_32098(17.5F, -65.0F, -0.5F, 1.0F, 62.0F, 1.0F, new class_5605(0.0F))
        .method_32101(193, 136).method_32098(14.0F, -73.0F, -19.0F, 5.0F, 70.0F, 5.0F, new class_5605(0.0F))
        .method_32101(0, 12).method_32098(-4.0F, -86.0F, -4.0F, 8.0F, 1.0F, 8.0F, new class_5605(0.0F))
        .method_32101(25, 22).method_32098(-2.0F, -85.0F, -2.0F, 4.0F, 6.0F, 4.0F, new class_5605(0.0F))
        .method_32101(25, 13).method_32098(-3.25F, -85.0F, -3.25F, 1.0F, 6.0F, 0.0F, new class_5605(0.0F))
        .method_32101(25, 12).method_32098(3.25F, -85.0F, -3.25F, 0.0F, 6.0F, 1.0F, new class_5605(0.0F))
        .method_32101(25, 12).method_32098(-3.25F, -85.0F, -3.25F, 0.0F, 6.0F, 1.0F, new class_5605(0.0F))
        .method_32101(25, 13).method_32098(2.25F, -85.0F, -3.25F, 1.0F, 6.0F, 0.0F, new class_5605(0.0F))
        .method_32101(5, 1).method_32098(2.25F, -85.0F, 3.25F, 1.0F, 6.0F, 0.0F, new class_5605(0.0F))
        .method_32101(5, 0).method_32098(3.25F, -85.0F, 2.25F, 0.0F, 6.0F, 1.0F, new class_5605(0.0F))
        .method_32101(5, 1).method_32098(-3.25F, -85.0F, 3.25F, 1.0F, 6.0F, 0.0F, new class_5605(0.0F))
        .method_32101(5, 0).method_32098(-3.25F, -85.0F, 2.25F, 0.0F, 6.0F, 1.0F, new class_5605(0.0F))
        .method_32101(0, 0).method_32098(-4.5F, -79.0F, -4.5F, 9.0F, 2.0F, 9.0F, new class_5605(0.0F))
        .method_32101(0, 22).method_32098(-3.0F, -86.85F, -3.0F, 6.0F, 1.0F, 6.0F, new class_5605(0.0F))
        .method_32101(193, 136).method_32096().method_32098(-19.0F, -73.0F, -19.0F, 5.0F, 70.0F, 5.0F, new class_5605(0.0F)).method_32106(false)
        .method_32101(193, 136).method_32098(-19.0F, -73.0F, 14.0F, 5.0F, 70.0F, 5.0F, new class_5605(0.0F))
        .method_32101(193, 136).method_32096().method_32098(14.0F, -73.0F, 14.0F, 5.0F, 70.0F, 5.0F, new class_5605(0.0F)).method_32106(false), class_5603.method_32090(0.0F, 0.0F, 0.0F));

        class_5610 cube_r1 = base.method_32117("cube_r1", class_5606.method_32108().method_32101(162, 136).method_32098(-0.5F, -31.0F, -7.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F)), class_5603.method_32091(17.5F, -34.0F, 7.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r2 = base.method_32117("cube_r2", class_5606.method_32108().method_32101(131, 136).method_32098(-0.5F, -31.0F, -7.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F)), class_5603.method_32091(17.5F, -34.0F, -7.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r3 = base.method_32117("cube_r3", class_5606.method_32108().method_32101(215, 123).method_32098(-0.5F, -31.0F, -7.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F)), class_5603.method_32091(7.0F, -34.0F, 17.5F, 0.0F, -1.5708F, 0.0F));

        class_5610 cube_r4 = base.method_32117("cube_r4", class_5606.method_32108().method_32101(164, 213).method_32098(-0.75F, -31.0F, -0.5F, 1.0F, 62.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32091(0.0F, -34.0F, 17.75F, 0.0F, 1.5708F, 0.0F));

        class_5610 cube_r5 = base.method_32117("cube_r5", class_5606.method_32108().method_32101(63, 202).method_32098(-0.5F, -31.0F, -7.0F, 1.0F, 62.0F, 14.0F, new class_5605(0.0F)), class_5603.method_32091(-7.0F, -34.0F, 17.5F, 0.0F, -1.5708F, 0.0F));

        class_5610 cube_r6 = base.method_32117("cube_r6", class_5606.method_32108().method_32101(38, 38).method_32096().method_32098(-18.0F, -2.5F, -4.0F, 36.0F, 5.0F, 4.0F, new class_5605(0.0F)).method_32106(false), class_5603.method_32091(0.0F, -68.5F, 17.0F, 0.0F, 3.1416F, 0.0F));

        class_5610 cube_r7 = base.method_32117("cube_r7", class_5606.method_32108().method_32101(6, 50).method_32098(-18.0F, -1.5F, -18.0F, 36.0F, 3.0F, 36.0F, new class_5605(0.0F)), class_5603.method_32091(0.0F, -67.25F, 0.0F, 0.0F, 0.0F, -3.1416F));

        class_5610 left_door2 = box.method_32117("left_door2", class_5606.method_32108().method_32101(93, 215).method_32098(0.0F, -33.0F, -1.0F, 14.0F, 62.0F, 1.0F, new class_5605(0.0F))
        .method_32101(276, 125).method_32098(12.8F, -6.0F, 0.0F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F))
        .method_32101(174, 213).method_32098(13.5F, -33.0F, -1.5F, 1.0F, 62.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(-14.0F, -32.0F, -17.0F));

        class_5610 cube_r8 = left_door2.method_32117("cube_r8", class_5606.method_32108().method_32101(276, 200).method_32098(-0.1F, -0.1F, -0.5F, 3.0F, 2.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32091(12.1F, 27.9F, 0.5F, 0.0F, 0.0F, -1.5708F));

        class_5610 cube_r9 = left_door2.method_32117("cube_r9", class_5606.method_32108().method_32101(297, 211).method_32098(-33.5F, -3.05F, -0.5F, 3.0F, 1.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32091(15.55F, -5.0F, 0.25F, 0.0F, 0.0F, -1.5708F));

        class_5610 pulltoopen = left_door2.method_32117("pulltoopen", class_5606.method_32108().method_32101(0, 12).method_32098(7.0083F, -2.3333F, -1.05F, 1.0F, 4.0F, 1.0F, new class_5605(0.0F))
        .method_32101(128, 233).method_32098(0.0083F, -4.8333F, -0.05F, 8.0F, 10.0F, 1.0F, new class_5605(0.0F))
        .method_32101(85, 182).method_32098(1.0083F, -4.3333F, -0.15F, 6.0F, 9.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32090(2.9917F, -10.1667F, -0.95F));

        class_5610 phone = pulltoopen.method_32117("phone", class_5606.method_32108().method_32101(278, 38).method_32098(-3.75F, -40.0F, -13.5F, 2.0F, 3.0F, 2.0F, new class_5605(-0.3F))
        .method_32101(278, 38).method_32098(-3.75F, -39.8F, -13.5F, 2.0F, 0.0F, 2.0F, new class_5605(0.0F))
        .method_32101(278, 44).method_32098(-3.75F, -37.75F, -13.5F, 2.0F, 3.0F, 2.0F, new class_5605(-0.5F))
        .method_32101(275, 26).method_32098(-8.5F, -40.0F, -13.5F, 5.0F, 6.0F, 2.0F, new class_5605(0.0F))
        .method_32101(278, 35).method_32098(-7.0F, -39.5F, -11.25F, 2.0F, 2.0F, 0.0F, new class_5605(0.0F))
        .method_32101(269, 36).method_32098(-5.5F, -42.0F, -13.5F, 2.0F, 2.0F, 2.0F, new class_5605(0.0F))
        .method_32101(269, 36).method_32098(-8.5F, -42.0F, -13.5F, 2.0F, 2.0F, 2.0F, new class_5605(0.0F))
        .method_32101(260, 36).method_32098(-5.5F, -42.0F, -13.5F, 2.0F, 2.0F, 2.0F, new class_5605(-0.2F))
        .method_32101(260, 36).method_32098(-8.5F, -42.0F, -13.5F, 2.0F, 2.0F, 2.0F, new class_5605(-0.2F))
        .method_32101(260, 26).method_32098(-9.0F, -41.5F, -14.5F, 6.0F, 8.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(9.5083F, 37.6667F, 14.95F));

        class_5610 right_door2 = box.method_32117("right_door2", class_5606.method_32108().method_32101(230, 200).method_32098(-14.0F, -33.0F, -1.0F, 14.0F, 62.0F, 1.0F, new class_5605(0.0F))
        .method_32101(276, 200).method_32098(-13.4F, -6.0F, 0.0F, 3.0F, 2.0F, 1.0F, new class_5605(0.0F))
        .method_32101(297, 211).method_32098(-13.95F, -5.5F, -0.25F, 3.0F, 1.0F, 1.0F, new class_5605(0.0F))
        .method_32101(0, 0).method_32098(-12.75F, -13.0F, -1.75F, 1.0F, 5.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(14.0F, -32.0F, -17.0F));

        class_5610 cube_r10 = right_door2.method_32117("cube_r10", class_5606.method_32108().method_32101(0, 0).method_32098(-0.75F, -3.0F, -2.5F, 1.0F, 5.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32091(-12.5F, -10.0F, -1.5F, 0.0F, 3.1416F, 0.0F));
        return class_5607.method_32110(modelData, 512, 512);
    }

    @Override
    public void renderDoors(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, boolean isBOTI) {
        DoorHandler door = tardis.door();

        if (!AITModClient.CONFIG.animateDoors) {
            this.left_door2.field_3675 = (door.isLeftOpen() || door.isOpen()) ? -4.75F : 0.0F;
            this.left_door2.field_3675 = (door.isRightOpen() || door.areBothOpen()) ? 4.75F : 0.0F;
        } else {
            float maxRot = 90f;
            this.right_door2.field_3675 = -(float) Math.toRadians(maxRot * door.getLeftRot());
            this.right_door2.field_3675 = (float) Math.toRadians(maxRot * door.getRightRot());
        }
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red,
                       float green, float blue, float alpha) {
        box.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void renderWithAnimations(ClientTardis tardis, ExteriorBlockEntity exterior, class_630 root, class_4587 matrices,
                                     class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha) {
        matrices.method_22903();
        matrices.method_22905(0.63F, 0.63F, 0.63F);
        matrices.method_46416(0, -1.5f, 0);

        this.renderDoors(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha, false);

        super.renderWithAnimations(tardis, exterior, root, matrices, vertices, light, overlay, red, green, blue, pAlpha);
        matrices.method_22909();
    }

    @Override
    public <T extends class_1297 & Linkable> void renderEntity(T falling, class_630 root, class_4587 matrices,
                                                           class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!falling.isLinked())
            return;

        matrices.method_22903();
        matrices.method_22905(0.63F, 0.63F, 0.63F);
        matrices.method_46416(0, -1.5f, 0);

        super.renderEntity(falling, root, matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public class_630 method_32008() {
        return box;
    }
}