package dev.amble.ait.client.models.items;

import org.jetbrains.annotations.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.client.model.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.util.AngleInterpolator;
import dev.amble.ait.core.item.RiftScannerItem;
import dev.amble.ait.core.world.TardisServerWorld;

public class RiftScannerModel extends class_3879 {

    public static final class_2960 TEXTURE = AITMod.id("textures/blockentities/items/rift_scanner.png");
    public static final class_2960 EMISSION = AITMod.id("textures/blockentities/items/rift_scanner_emission.png");

    private static final float MULTIPLIER = (float) (360 * Math.PI / 180);

    private final AngleInterpolator aimedInterpolator = new AngleInterpolator();
    private final AngleInterpolator aimlessInterpolator = new AngleInterpolator();

    private final class_630 root;

    public RiftScannerModel(class_630 root) {
        super(class_1921::method_23576);
        this.root = root.method_32086("root");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 root = modelPartData.method_32117("root", class_5606.method_32108()
                .method_32101(29, 1).method_32098(-10.5F, -11.0F, 7.0F, 5.0F, 10.0F, 2.0F, new class_5605(0.0F))
                .method_32101(18, 10).method_32098(-7.0F, -6.0F, 6.9F, 1.0F, 1.0F, 0.0F, new class_5605(0.0F))
                .method_32101(19, 10).method_32098(-6.7F, -5.7F, 6.8F, 0.4F, 0.4F, 0.0F, new class_5605(0.0F))
                .method_32101(11, 9).method_32098(-10.0F, -2.5F, 6.9F, 1.0F, 1.0F, 0.0F, new class_5605(0.0F))
                .method_32101(20, 6).method_32098(-11.5F, -8.0F, 7.5F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F))
                .method_32101(16, 6).method_32098(-11.5F, -10.1F, 7.5F, 1.0F, 2.0F, 1.0F, new class_5605(0.0F))
                .method_32101(0, 12).method_32098(-11.25F, -8.0F, 8.0F, 4.0F, 9.0F, 0.0F, new class_5605(0.0F))
                .method_32101(20, 7).method_32098(-11.5F, -11.4F, 7.5F, 1.0F, 1.0F, 1.0F, new class_5605(0.0F))
                .method_32101(16, 0).method_32098(-11.3F, -12.4F, 7.7F, 0.6F, 5.0F, 0.6F, new class_5605(0.0F))
                .method_32101(0, 3).method_32098(-11.1F, -17.4F, 8.0F, 0.2F, 5.0F, 0.0F, new class_5605(0.0F))
                .method_32101(0, 0).method_32098(-9.5F, -14.5F, 6.5F, 3.0F, 3.0F, 0.0F, new class_5605(0.0F))
                .method_32101(7, 3).method_32098(-9.5F, -14.5F, 9.5F, 3.0F, 3.0F, 0.0F, new class_5605(0.0F))
                .method_32101(0, -3).method_32098(-9.5F, -14.5F, 6.5F, 0.0F, 3.0F, 3.0F, new class_5605(0.0F))
                .method_32101(-2, 3).method_32098(-9.5F, -11.5F, 6.5F, 3.0F, 0.0F, 3.0F, new class_5605(0.0F))
                .method_32101(3, 0).method_32098(-9.5F, -14.5F, 6.5F, 3.0F, 0.0F, 3.0F, new class_5605(0.0F))
                .method_32101(7, 0).method_32098(-6.5F, -14.5F, 6.5F, 0.0F, 3.0F, 3.0F, new class_5605(0.0F))
                .method_32101(19, 0).method_32098(-9.0F, -11.5F, 7.0F, 2.0F, 1.0F, 2.0F, new class_5605(-0.001F))
                .method_32101(53, 0).method_32098(-8.5F, -6.75F, 5.0F, 1.0F, 5.0F, 2.0F, new class_5605(0.0F))
                .method_32101(44, 0).method_32098(-5.25F, -10.2F, 7.25F, 1.5F, 9.0F, 1.5F, new class_5605(0.0F))
                .method_32101(0, 20).method_32098(-5.5F, -9.7F, 7.75F, 0.3F, 8.0F, 0.5F, new class_5605(0.0F))
                .method_32101(18, 9).method_32098(-5.25F, -9.7F, 7.25F, 1.5F, 1.0F, 1.5F, new class_5605(0.1F))
                .method_32101(18, 9).method_32098(-5.25F, -2.7F, 7.25F, 1.5F, 1.0F, 1.5F, new class_5605(0.1F))
                .method_32101(8, 7).method_32098(-10.0F, -10.5F, 6.5F, 0.5F, 4.0F, 1.0F, new class_5605(0.0F))
                .method_32101(8, 7).method_32098(-6.5F, -10.5F, 6.5F, 0.5F, 4.0F, 1.0F, new class_5605(0.0F))
                .method_32101(7, 9).method_32098(-9.5F, -10.5F, 6.5F, 3.0F, 0.5F, 1.0F, new class_5605(0.0F))
                .method_32101(8, 9).method_32098(-9.5F, -7.0F, 6.5F, 3.0F, 0.5F, 1.0F, new class_5605(0.0F))
                .method_32101(0, 8).method_32098(-9.9F, -10.4F, 6.85F, 3.8F, 3.8F, 0.0F, new class_5605(0.0F)), class_5603.method_32090(8.0F, 24.0F, -8.0F));

        root.method_32117("arrow", class_5606.method_32108().method_32101(1, 6).method_32098(-0.2F, -1.4F, 1.75F, 0.4F, 1.9F, 0.0F, new class_5605(0.0F)), class_5603.method_32091(-8.0F, -8.5F, 5.0F, 0.0F, 0.0F, 0F));

        root.method_32117("cube_r1", class_5606.method_32108().method_32101(18, 11).method_32098(-1.45F, 6.9F, 0.0F, 2.9F, 1.0F, 0.0F, new class_5605(0.0F))
                .method_32101(18, 8).method_32098(0.0F, 6.9F, -1.45F, 0.0F, 1.0F, 2.9F, new class_5605(0.0F))
                .method_32101(18, 11).method_32098(-1.55F, -0.1F, 0.0F, 3.0F, 1.0F, 0.0F, new class_5605(0.0F))
                .method_32101(18, 8).method_32098(0.0F, -0.1F, -1.45F, 0.0F, 1.0F, 3.0F, new class_5605(0.0F)), class_5603.method_32091(-4.5F, -9.5F, 8.0F, 0.0F, 0.7854F, 0.0F));

        root.method_32117("cube_r2", class_5606.method_32108().method_32101(10, 9).method_32098(-0.1F, -0.5F, -1.4F, 0.2F, 1.0F, 0.3F, new class_5605(0.0F))
                .method_32101(10, 11).method_32098(-0.5F, -0.5F, -1.1F, 1.0F, 1.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32091(-9.5F, -5.5F, 8.0F, 0.0F, 0.0F, 0.7854F));

        root.method_32117("cube_r3", class_5606.method_32108().method_32101(19, 10).method_32098(-0.5F, -0.5F, -1.1F, 1.0F, 1.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32091(-6.5F, -2.0F, 8.0F, 0.0F, 0.0F, 0.3927F));

        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        root.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    public void setAngles(class_4587 matrices, class_811 renderMode, boolean left) {
        matrices.method_22904(0.5, -1.75, -0.5);

        if (renderMode == class_811.field_4317)
            matrices.method_22904(0, 0.2, 0);
    }

    public void render(@Nullable class_638 world, @Nullable class_1309 entity, class_1799 stack, class_4587 matrices, class_4597 provider, int light, int overlay, int seed) {
        this.root.method_32086("arrow").field_3674 = this.unclampedCall(stack, world, entity, seed) * MULTIPLIER;
        this.method_2828(matrices, provider.getBuffer(class_1921.method_23576(TEXTURE)), light, overlay, 1, 1, 1, 1);
        this.method_2828(matrices, provider.getBuffer(class_1921.method_23576(EMISSION)), 0xf000f0, overlay, 1, 1, 1, 1);
    }

    public float unclampedCall(class_1799 stack, @Nullable class_638 clientWorld, @Nullable class_1309 livingEntity, int i) {
        class_1297 entity = livingEntity != null ? livingEntity : stack.method_27319();

        if (entity == null)
            return 0;

        clientWorld = this.getClientWorld(entity, clientWorld);

        return clientWorld == null ? 0.0F : this.getAngle(RiftScannerItem.getTarget(stack)
                .method_33943(75), clientWorld, i, entity);
    }

    private float getAngle(class_2338 target, class_638 world, int seed, class_1297 entity) {
        long l = world.method_8510();
        return !this.canPointTo(entity, target, world)
                ? this.getAimlessAngle(seed, l)
                : this.getAngleTo(entity, l, target);
    }

    private float getAimlessAngle(int seed, long time) {
        if (this.aimlessInterpolator.shouldUpdate(time))
            this.aimlessInterpolator.update(time, Math.random());

        double d = this.aimlessInterpolator.value() + (double) ((float) this.scatter(seed) / 2.14748365E9F);
        return class_3532.method_15341((float) d, 1.0F);
    }

    private int scatter(int seed) {
        return seed * 1327217883;
    }

    private boolean canPointTo(class_1297 entity, @Nullable class_2338 pos, @Nullable class_638 world) {
        return world != null && !TardisServerWorld.isTardisDimension(world) &&
                pos != null && !(pos.method_19770(entity.method_19538()) < 9.999999747378752E-6);
    }

    private @Nullable class_638 getClientWorld(class_1297 entity, @Nullable class_638 world) {
        return world == null && entity.method_37908() instanceof class_638 ? (class_638) entity.method_37908() : world;
    }

    private double getAngleTo(class_1297 entity, class_2338 pos) {
        class_243 vec3d = class_243.method_24953(pos);
        return Math.atan2(vec3d.method_10215() - entity.method_23321(), vec3d.method_10216() - entity.method_23317()) / 6.2831854820251465;
    }

    private float getAngleTo(class_1297 entity, long time, class_2338 pos) {
        double d = this.getAngleTo(entity, pos);
        double e = this.getBodyYaw(entity);
        double f;
        if (entity instanceof class_1657 playerEntity) {
            if (playerEntity.method_7340()) {
                if (this.aimedInterpolator.shouldUpdate(time)) {
                    this.aimedInterpolator.update(time, 0.5 - (e - 0.25));
                }

                f = d + this.aimedInterpolator.value();
                return class_3532.method_15341((float) f, 1.0F);
            }
        }

        f = 0.5 - (e - 0.25 - d);
        return class_3532.method_15341((float) f, 1.0F);
    }

    private double getBodyYaw(class_1297 entity) {
        return class_3532.method_15367(entity.method_43078() / 360.0F, 1.0);
    }
}