package dev.amble.ait.client.models.json;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.*;
import com.mojang.datafixers.util.Either;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class JsonEntityModel {

    static final Gson GSON = new GsonBuilder()
            .registerTypeAdapter(JsonEntityModel.class, new JsonEntityModel.Deserializer())
            /*.registerTypeAdapter(ModelElement.class, new ModelElement.Deserializer())
            .registerTypeAdapter(ModelElementFace.class, new ModelElementFace.Deserializer())
            .registerTypeAdapter(ModelElementTexture.class, new ModelElementTexture.Deserializer())
            .registerTypeAdapter(Transformation.class, new Transformation.Deserializer())
            .registerTypeAdapter(ModelTransformation.class, new ModelTransformation.Deserializer())
            .registerTypeAdapter(ModelOverride.class, new ModelOverride.Deserializer())*/
            .create();

    private final List<class_785> elements;

    @Nullable private final class_793.class_4751 guiLight;
    @Nullable private final Boolean ambientOcclusion;

    private final class_809 transformations;
    private final List<class_799> overrides;
    public String id = "";

    protected final Map<String, Either<class_4730, String>> textureMap;

    @Nullable protected JsonEntityModel parent;
    @Nullable protected class_2960 parentId;

    public JsonEntityModel(@Nullable class_2960 parentId, List<class_785> elements, Map<String, Either<class_4730, String>> textureMap, @Nullable Boolean ambientOcclusion, @Nullable class_793.class_4751 guiLight, class_809 transformations, List<class_799> overrides) {
        this.elements = elements;
        this.ambientOcclusion = ambientOcclusion;
        this.guiLight = guiLight;
        this.textureMap = textureMap;
        this.parentId = parentId;
        this.transformations = transformations;
        this.overrides = overrides;
    }

    public JsonEntityModel getRootModel() {
        return this.parent == null ? this : this.parent.getRootModel();
    }

    public List<class_785> getElements() {
        if (this.elements.isEmpty() && this.parent != null) {
            return this.parent.getElements();
        }
        return this.elements;
    }

    public class_793.class_4751 getGuiLight() {
        if (this.guiLight != null) {
            return this.guiLight;
        }
        if (this.parent != null) {
            return this.parent.getGuiLight();
        }
        return class_793.class_4751.field_21859;
    }

    public void bake(class_7775 baker, class_793 parent, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_2960 id, boolean hasDepth) {
        /*ModelData modelData = new ModelData();
        ModelPartData modelPartData = modelData.getRoot();

        Sprite sprite = textureGetter.apply(this.resolveSprite(PARTICLE_KEY));
        BasicBakedModel.Builder builder = new BasicBakedModel.Builder(this, this.compileOverrides(baker, parent), hasDepth).setParticle(sprite);

        int counter = 0;
        int face = 0;
        for (ModelElement modelElement : this.elements) {


            ModelTransform transform = getModelTransform(modelElement);




            for (Direction direction : modelElement.faces.keySet()) {
                ModelElementFace modelElementFace = modelElement.faces.get(direction);
                modelElementFace.textureData;

                modelPartData.addChild(counter + "_" + face, ModelPartBuilder.create().cuboid(
                                modelElement.from.x, modelElement.from.y, modelElement.from.z,
                                modelElement.to.x, modelElement.to.y, modelElement.to.z, modelElement.faces.keySet()
                        ).uv(modelElementFace.textureData.getU(0), modelElementFace.textureData.getU(1)), transform
                );

                Sprite sprite2 = textureGetter.apply(this.resolveSprite(modelElementFace.textureId));
                if (modelElementFace.cullFace == null) {
                    builder.addQuad(JsonUnbakedModel.createQuad(modelElement, modelElementFace, sprite2, direction, settings, id));
                    continue;
                }
                builder.addQuad(Direction.transform(settings.getRotation().getMatrix(), modelElementFace.cullFace), JsonUnbakedModel.createQuad(modelElement, modelElementFace, sprite2, direction, settings, id));


                face++;
            }

            face = 0;
            counter++;
        }*/
    }

    private static @NotNull class_5603 getModelTransform(class_785 modelElement) {
        Vector3f origin = modelElement.field_4232.comp_1118();
        float angle = modelElement.field_4232.comp_1120();
        class_2350.class_2351 axis = modelElement.field_4232.comp_1119();

        class_5603 transform = switch (axis) {
            case field_11048 -> class_5603.method_32091(origin.x, origin.y, origin.z, angle, 0, 0);
            case field_11052 -> class_5603.method_32091(origin.x, origin.y, origin.z, 0, angle, 0);
            case field_11051 -> class_5603.method_32091(origin.x, origin.y, origin.z, 0, 0, angle);
        };
        return transform;
    }

    @Environment(EnvType.CLIENT)
    public static class Deserializer
            implements JsonDeserializer<JsonEntityModel> {
        @Override
        public JsonEntityModel deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            List<class_785> list = this.elementsFromJson(context, jsonObject);
            String string = this.parentFromJson(jsonObject);
            Map<String, Either<class_4730, String>> map = this.texturesFromJson(jsonObject);
            Boolean boolean_ = this.ambientOcclusionFromJson(jsonObject);
            class_809 modelTransformation = class_809.field_4301;
            if (jsonObject.has("display")) {
                JsonObject jsonObject2 = class_3518.method_15296(jsonObject, "display");
                modelTransformation = context.deserialize(jsonObject2, class_809.class);
            }
            List<class_799> list2 = this.overridesFromJson(context, jsonObject);
            class_793.class_4751 guiLight = null;
            if (jsonObject.has("gui_light")) {
                guiLight = class_793.class_4751.method_24300(class_3518.method_15265(jsonObject, "gui_light"));
            }
            class_2960 identifier = string.isEmpty() ? null : new class_2960(string);
            return new JsonEntityModel(identifier, list, map, boolean_, guiLight, modelTransformation, list2);
        }

        protected List<class_799> overridesFromJson(JsonDeserializationContext context, JsonObject object) {
            ArrayList<class_799> list = Lists.newArrayList();
            if (object.has("overrides")) {
                JsonArray jsonArray = class_3518.method_15261(object, "overrides");
                for (JsonElement jsonElement : jsonArray) {
                    list.add(context.deserialize(jsonElement, class_799.class));
                }
            }
            return list;
        }

        private Map<String, Either<class_4730, String>> texturesFromJson(JsonObject object) {
            class_2960 identifier = class_1059.field_5275;
            HashMap<String, Either<class_4730, String>> map = Maps.newHashMap();
            if (object.has("textures")) {
                JsonObject jsonObject = class_3518.method_15296(object, "textures");
                for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                    map.put(entry.getKey(), Deserializer.resolveReference(identifier, entry.getValue().getAsString()));
                }
            }
            return map;
        }

        private static Either<class_4730, String> resolveReference(class_2960 id, String name) {
            if (name.charAt(0) == '#')
                return Either.right(name.substring(1));

            class_2960 identifier = class_2960.method_12829(name);

            if (identifier == null)
                throw new JsonParseException(name + " is not valid resource location");

            return Either.left(new class_4730(id, identifier));
        }

        private String parentFromJson(JsonObject json) {
            return class_3518.method_15253(json, "parent", "");
        }

        @Nullable protected Boolean ambientOcclusionFromJson(JsonObject json) {
            if (json.has("ambientocclusion")) {
                return class_3518.method_15270(json, "ambientocclusion");
            }
            return null;
        }

        protected List<class_785> elementsFromJson(JsonDeserializationContext context, JsonObject json) {
            ArrayList<class_785> list = Lists.newArrayList();
            if (json.has("elements")) {
                for (JsonElement jsonElement : class_3518.method_15261(json, "elements")) {
                    list.add(context.deserialize(jsonElement, class_785.class));
                }
            }
            return list;
        }
    }
}
