package dev.amble.ait.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_742;
import net.minecraft.class_8012;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.Tardis;

public class RWFOverlay implements HudRenderCallback {
    private static final int ALPHA_GRAY = class_5253.class_5254.method_27764(125, 255, 255, 255);
    @Override
    public void onHudRender(class_332 drawContext, float tickDelta) {
        class_310 mc = class_310.method_1551();

        if (mc.field_1724 == null || mc.field_1687 == null)
            return;

        if (mc.field_1724.method_5765() &&   mc.field_1724.method_5854() instanceof FlightTardisEntity entity) {
            if (!entity.isLinked()) return;
            Tardis tardis = entity.tardis().get();
            Yaw.render(drawContext, mc.field_1724);
            Position.render(drawContext, mc.field_1724, mc);
            Position.Y.render(drawContext, mc.field_1724, mc);
            Speed.render(drawContext, mc.field_1724, mc);
            //this.renderOverlay(drawContext, AITMod.id("textures/gui/tardis/rwf_gui.png"));
        }
    }

    private void renderOverlay(class_332 context, class_2960 texture) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
        context.method_25291(texture, (context.method_51421() / 2) - 8,
                (context.method_51443() / 2) - 8, 0, 0.0F, 0.0F, 16, 16, 16, 16);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
    }

    private static int width() {
        return class_310.method_1551().method_22683().method_4486();
    }
    private static int height() {
        return class_310.method_1551().method_22683().method_4502() - 8;
    }


    private static void renderIncrementedLine(class_332 context, int x, int gap) {
        context.method_25301(x, 0, height(), ALPHA_GRAY);

        // horizontal line every gap
        /*
        for (int i = 0; i < getScreenHeight(); i += gap) {
            context.drawHorizontalLine(x, x + 3, i, ALPHA_GRAY);
        }*/
    }

    private static class Yaw {
        private static void render(class_332 context, class_742 player) {
            context.method_25292(60, width() - 60, 20, ALPHA_GRAY);
            context.method_25301(60, 16, 24, class_8012.field_42973);
            context.method_25301(width() - 60, 16, 24, class_8012.field_42973);

            float current = player.method_36454();

            line(context, -180, current, false);
            line(context, -90, current, false);
            line(context, 0, current, false);
            line(context, 90, current, false);
            line(context, 180, current, false);

            line(context, player.method_36454(), 0, true);
        }

        private static void line(class_332 context, float yaw, float current, boolean isPrimary) {
            int x = isPrimary ? width() / 2 : position(yaw, current);

            int middle = width() / 2;
            if (!isPrimary && (middle - 10 <= x && x <= middle + 10)) return;

            int color = isPrimary ? class_8012.field_42973 : ALPHA_GRAY;

            context.method_25301(x, 16, 24, color);
            context.method_25300(class_310.method_1551().field_1772, Math.round(class_3532.method_15393(yaw)) + "", x, 26, color);

            class_2350 dir = class_2350.method_10150(yaw);
            context.method_25300(class_310.method_1551().field_1772, dir.method_15434().toUpperCase().charAt(0) + "", x, 35, color);
        }
        private static int position(float yaw, float current) {
            return (int) ((width() - 120) * (((class_3532.method_15393(yaw - current) + 180) / 360))) + 60;
        }
    }
    private static class Pitch {
        private static void render(class_332 context, class_742 player) {
            renderIncrementedLine(context, 10, 5);

            line(context, 0, false);
            line(context, 45, false);
            line(context, -45, false);

            line(context, player.method_36455(), true);
        }

        private static void line(class_332 context, float pitch, boolean isPrimary) {
            int y = position(pitch);
            int color = isPrimary ? class_8012.field_42973 : ALPHA_GRAY;

            context.method_25292(10, 15, y + 3, color);
            context.method_25300(class_310.method_1551().field_1772, Math.round(pitch) + "", 27, y, color);
        }

        private static int position(float pitch) {
            return (int) (height() * (((pitch + 90) / 180)));
        }
    }
    private static class Position {
        private static class Y {
            private static void render(class_332 context, class_742 player, class_310 client) {
                int bottom = Math.abs(player.method_37908().method_31607());
                int range = player.method_37908().method_31600() + (Math.min(bottom, 0));

                renderIncrementedLine(context, width() - 10, 8);

                line(context, range / 2d, bottom, range, false);
                line(context, range / 4d, bottom, range, false);
                line(context, 0d, 128, range, false);

                line(context, player.method_23318(), bottom, range, true);
            }

            private static void line(class_332 context, double y, int bottom, int range, boolean isPrimary) {
                int yPosition = position(y, bottom, range);
                int color = isPrimary ? class_8012.field_42973 : ALPHA_GRAY;

                context.method_25292(width() - 15, width() - 10, yPosition + 3, color);

                class_327 renderer = class_310.method_1551().field_1772;
                String text = Math.round(y) + "";
                context.method_25303(renderer, text, width() - renderer.method_1727(text) - 17 , yPosition, color);
            }

            private static int position(double y, int bottom, int range) {
                return (int) (height() * (1f - ((float) (y + bottom) / range)));
            }
        }

        private static void render(class_332 context, class_742 player, class_310 client) {
            String i = Math.round(player.method_23317()) + ", " + Math.round(player.method_23321());
            context.method_25294(width() - 62 - client.field_1772.method_1727(i), 48, width() - 58, 61, ALPHA_GRAY);
            context.method_25303(client.field_1772, i, width() - 60 - client.field_1772.method_1727(i), 50, 0xFFFFFF);
        }
    }
    private static class Speed {
        private static void render(class_332 context, class_742 player, class_310 client) {
            double deltaX = player.method_23317() - player.field_6014;
            double deltaZ = player.method_23321() - player.field_5969;
            double deltaY = player.method_23318() - player.field_6036;
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            String s = Math.round(distance * 20) + " m/s";

            context.method_25294(58, 49, 62 + client.field_1772.method_1727(s), 60, ALPHA_GRAY);
            context.method_25303(client.field_1772, s, 60, 50, 0xFFFFFF);
        }
    }
}
