package dev.amble.ait.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.item.SonicItem;

public class SonicOverlay implements HudRenderCallback {
    @Override
    public void onHudRender(class_332 drawContext, float v) {
        class_310 mc = class_310.method_1551();

        if (mc.field_1724 == null || mc.field_1687 == null)
            return;

        if (!mc.field_1690.method_31044().method_31034())
            return;

        if ((mc.field_1724.method_6118(class_1304.field_6173).method_7909() == AITItems.SONIC_SCREWDRIVER
                || mc.field_1724.method_6118(class_1304.field_6171).method_7909() == AITItems.SONIC_SCREWDRIVER)
                && playerIsLookingAtSonicInteractable(mc.field_1765, mc.field_1724)) {
            this.renderOverlay(drawContext,
                    AITMod.id("textures/gui/overlay/sonic_can_interact.png"));
        }
    }

    private boolean playerIsLookingAtSonicInteractable(class_239 crosshairTarget, class_1657 player) {
        if (player != null) {
            if (player.method_6047().method_7909() instanceof SonicItem) {
                class_1799 sonic = player.method_6047();
                if (sonic == null)
                    return false;
                class_2487 nbt = sonic.method_7948();
                if (!nbt.method_10545(SonicItem.FUEL_KEY))
                    return false;
                if (crosshairTarget.method_17783() == class_239.class_240.field_1332) {
                    class_2248 block = player.method_37908().method_8320(((class_3965) crosshairTarget).method_17777())
                            .method_26204();
                    return !(block instanceof class_2189) && nbt.method_10574(SonicItem.FUEL_KEY) > 0
                            && player.method_37908().method_8320(((class_3965) crosshairTarget).method_17777())
                            .method_26164(AITTags.Blocks.SONIC_INTERACTABLE);
                }
            } else if (player.method_6079().method_7909() instanceof SonicItem) {
                class_1799 sonic = player.method_6079();
                if (sonic == null)
                    return false;
                class_2487 nbt = sonic.method_7948();
                if (!nbt.method_10545(SonicItem.FUEL_KEY))
                    return false;
                if (crosshairTarget.method_17783() == class_239.class_240.field_1332) {
                    class_2248 block = player.method_37908().method_8320(((class_3965) crosshairTarget).method_17777())
                            .method_26204();
                    return !(block instanceof class_2189) && nbt.method_10574(SonicItem.FUEL_KEY) > 0
                            && player.method_37908().method_8320(((class_3965) crosshairTarget).method_17777())
                            .method_26164(AITTags.Blocks.SONIC_INTERACTABLE);
                }
            }
        }
        return false;
    }

    private void renderOverlay(class_332 context, class_2960 texture) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();

        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);

        context.method_25291(texture, (context.method_51421() / 2) - 8,
                (context.method_51443() / 2) - 24, 0, 0.0F, 0.0F, 16, 16, 16, 16);

        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
    }

}
