package dev.amble.ait.client.renderers;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.joml.Matrix4f;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.data.ClientLandingManager;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.landing.LandingPadSpot;

public class LandingRegionRenderer {

    private static final int DARK_CYAN = class_5253.class_5254.method_27764(255, 0, 155, 155);

    private static final class_2960 AVAILABLE = AITMod.id("textures/marker/available.png");
    private static final class_2960 OCCUPIED = AITMod.id("textures/marker/occupied.png");

    private final class_310 client;
    private class_2960 previous;

    public LandingRegionRenderer(class_310 client) {
        this.client = client;
    }

    private static class_2960 getTexture(LandingPadSpot spot) {
        return spot.isOccupied() ? OCCUPIED : AVAILABLE;
    }

    public boolean shouldRender() {
        return SonicRendering.isPlayerHoldingScanningSonic() && ClientLandingManager.getInstance().getRegion(client.field_1724.method_31476()) != null;
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        class_3695 profiler = client.field_1687.method_16107();

        profiler.method_15405("landing_pad");

        profiler.method_15396("region");
        renderRegion();
        profiler.method_15405("chunk");
        renderChunk(matrices, vertexConsumers, cameraX, cameraY, cameraZ);

        profiler.method_15407();
    }

    private void renderRegion() {
        class_3695 profiler = client.field_1687.method_16107();

        profiler.method_15396("get");
        LandingPadRegion region = ClientLandingManager.getInstance().getRegion(client.field_1724.method_31476());

        if (region == null)
            return;

        profiler.method_15405("iterate");
        List<LandingPadSpot> spots = region.getSpots();

        for (int i = 0; i < spots.size(); i++) {
            boolean isLast = i == spots.size() - 1;
            renderSpot(spots.get(i), isLast);
        }

        this.previous = null;

        profiler.method_15407();
    }

    private void renderSpot(LandingPadSpot spot, boolean forceRender) {
        class_2960 text = getTexture(spot);
        SonicRendering.renderFloorTexture(spot.getPos().method_10069(0, -1, 0), text, forceRender ? null : this.previous, true);

        forceRender = forceRender || !text.equals(this.previous);

        this.previous = forceRender ? null : text;
    }

    private void renderChunk(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        int k = DARK_CYAN;
        int j;
        class_1297 entity = this.client.field_1773.method_19418().method_19331();
        float f = (float)((double)this.client.field_1687.method_31607() - cameraY);
        float g = (float)((double)this.client.field_1687.method_31600() - cameraY);
        class_1923 chunkPos = entity.method_31476();
        float h = (float)((double)chunkPos.method_8326() - cameraX);
        float i = (float)((double)chunkPos.method_8328() - cameraZ);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043(1.0));
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        for (j = 2; j < 16; j += 2) {
            vertexConsumer.method_22918(matrix4f, h + (float)j, f, i).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, f, i).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, g, i).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, g, i).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + 16.0f).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + 16.0f).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + 16.0f).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + 16.0f).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
        }
        for (j = 2; j < 16; j += 2) {
            vertexConsumer.method_22918(matrix4f, h, f, i + (float)j).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, f, i + (float)j).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h, g, i + (float)j).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h, g, i + (float)j).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, f, i + (float)j).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, f, i + (float)j).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, g, i + (float)j).method_39415(k).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, g, i + (float)j).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
        }
        for (j = this.client.field_1687.method_31607(); j <= this.client.field_1687.method_31600(); j += 2) {
            float l = (float)((double)j - cameraY);
            int m = DARK_CYAN;
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_39415(m).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i + 16.0f).method_39415(m).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i + 16.0f).method_39415(m).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i).method_39415(m).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_39415(m).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 1.0f, 0.0f, 0.0f).method_1344();
        }
        vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043(2.0));
        for (j = 0; j <= 16; j += 16) {
            for (int k2 = 0; k2 <= 16; k2 += 16) {
                vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + (float)k2).method_22915(0.25f, 0.25f, 1.0f, 0.0f).method_1344();
                vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + (float)k2).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
                vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + (float)k2).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
                vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + (float)k2).method_22915(0.25f, 0.25f, 1.0f, 0.0f).method_1344();
            }
        }
        for (j = this.client.field_1687.method_31607(); j <= this.client.field_1687.method_31600(); j += 16) {
            float l = (float)((double)j - cameraY);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(0.25f, 0.25f, 1.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i + 16.0f).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i + 16.0f).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(0.25f, 0.25f, 1.0f, 1.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(0.25f, 0.25f, 1.0f, 0.0f).method_1344();
        }
    }

    public void tryRender(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        if (!this.shouldRender())
            return;

        this.render(matrices, vertexConsumers, cameraX, cameraY, cameraZ);
    }

    private static LandingRegionRenderer INSTANCE;

    public static LandingRegionRenderer getInstance() {
        if (INSTANCE == null)
            INSTANCE = new LandingRegionRenderer(class_310.method_1551());

        return INSTANCE;
    }
}
