package dev.amble.ait.client.renderers;

import dev.amble.ait.core.engine.block.multi.MultiBlockStructure;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_638;


public class MultiBlockStructureRenderer {

    private final class_310 client;
    private final class_3695 profiler;

    protected MultiBlockStructureRenderer(class_310 client) {
        this.client = client;
        this.profiler = client.method_16011();
    }

    private MultiBlockStructureRenderer() {
        this(class_310.method_1551());
    }

    public void render(MultiBlockStructure structure, class_2338 centre, class_1920 view, class_4587 matrices, class_4597 provider, boolean holographic) {
        profiler.method_15396("multi_block_structure");
        profiler.method_15396("iterate_offsets");
        structure.forEach(offset -> renderOffset(offset, centre, view, matrices, provider, holographic));
    }

    public void renderForInterior(MultiBlockStructure structure, class_2338 centre, class_1920 view, class_4587 matrices, class_4597 provider, boolean holographic) {
        profiler.method_15396("multi_block_structure");
        profiler.method_15396("iterate_offsets");
        structure.forEach(offset -> renderOffsetInterior(offset, centre, view, matrices, provider, holographic));
        profiler.method_15407();
        profiler.method_15407();
    }

    public void renderOffsetInterior(MultiBlockStructure.BlockOffset offset, class_2338 centre, class_1920 view, class_4587 matrices, class_4597 provider, boolean holographic) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) return;

        class_2338 pos = centre.method_10081(offset.offset());
        class_2338 diff = pos.method_10059(centre);
        class_2680 state = this.getBlock(offset.block()).method_9564();
        class_2586 entity = world.method_8321(offset.offset());

        matrices.method_22903();
        matrices.method_46416(diff.method_10263(), diff.method_10264(), diff.method_10260());

        if (holographic) {
            matrices.method_22905(0.35f, 0.35f, 0.35f);
            matrices.method_22904(0.95, 1, 1);
        }

        renderCulledBlocks(state, pos, view, matrices, provider);
        if (entity != null) {
            renderBlockEntities(entity, matrices, provider);
        }
        matrices.method_22909();
    }

    private void renderCulledBlocks(class_2680 state, class_2338 pos, class_1920 view, class_4587 matrices, class_4597 provider) {
        client.method_1541().method_3355(state, pos, view, matrices, provider.getBuffer(class_4696.method_23679(state)), true, client.field_1687.field_9229);
    }

    private void renderBlockEntities(class_2586 entity,  class_4587 matrices, class_4597 provider) {
        client.method_31975().method_3555(entity, class_310.method_1551().method_1488(), matrices, provider);
    }

    public void renderOffset(MultiBlockStructure.BlockOffset offset, class_2338 centre, class_1920 view, class_4587 matrices, class_4597 provider, boolean holographic) {
        class_2338 pos = centre.method_10081(offset.offset());

        class_2338 diff = pos.method_10059(centre);
        class_2680 state = this.getBlock(offset.block()).method_9564();

        matrices.method_22903();
        matrices.method_46416(diff.method_10263(), diff.method_10264(), diff.method_10260());

        if (holographic) {
            matrices.method_22905(0.35f, 0.35f, 0.35f);
            matrices.method_22904(0.95, 1, 1);
        }

        renderBlock(state, pos, view, matrices, provider);
        matrices.method_22909();
    }

    private void renderBlock(class_2680 state, class_2338 pos, class_1920 view, class_4587 matrices, class_4597 provider) {
        client.method_1541().method_3350().method_3374(view, client.method_1541().method_3349(state), state, pos, matrices, provider.getBuffer(class_4696.method_23679(state)), false, client.field_1687.field_9229, state.method_26190(pos), class_4608.field_21444);
    }

    private class_2248 getBlock(MultiBlockStructure.AllowedBlocks block) {
        return (class_2248) block.toArray()[0];
    }

    private static MultiBlockStructureRenderer INSTANCE;

    public static MultiBlockStructureRenderer instance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiBlockStructureRenderer();
        }
        return INSTANCE;
    }
}
