package dev.amble.ait.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_8012;
import net.minecraft.client.render.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.SubSystemBlockEntity;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;

public class SonicRendering {
    private static final class_2960 SELECTED = AITMod.id("textures/marker/landing.png");
    public static final class_2960 SELECTED_RED = AITMod.id("textures/marker/landing_red.png");

    private final class_310 client;
    private final class_3695 profiler;

    public SonicRendering(class_310 client) {
        this.client = client;
        this.profiler = client.method_16011();
    }
    public SonicRendering() {
        this(class_310.method_1551());
    }

    public static void renderFloorTexture(class_2338 pos, class_2960 texture, @Nullable class_2960 previous, boolean spinning) {
        renderFloorTexture(new class_243(pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1), texture, previous, spinning);
    }

    public static void renderFloorTexture(class_243 target, class_2960 texture, @Nullable class_2960 previous, boolean spinning) {
        class_3695 profiler = class_310.method_1551().field_1687.method_16107();

        profiler.method_15396("get");
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        class_4587 matrices = new class_4587();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Matrix4f positionMatrix = matrices.method_23760().method_23761();

        profiler.method_15405("transform");
        class_243 transform = target.method_1020(camera.method_19326());

        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180f));
        matrices.method_22904(transform.field_1352 - 0.5f, transform.field_1351 + 0.05f, transform.field_1350 - 0.5f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90f));

        if (spinning) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees(client.field_1724.field_6012 / 200f * 360f));
        }
        matrices.method_46416(-0.5f, 0.5f, 0f);

        profiler.method_15405("vertexes");

        if (!buffer.method_22893()) buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);

        buffer.method_22918(positionMatrix, 0, 0, 0).method_22915(1f, 1f, 1f, 1f).method_22913(0f, 0f).method_1344();
        buffer.method_22918(positionMatrix, 0, -1, 0).method_22915(1f, 1f, 1f, 1f).method_22913(0f, 1f).method_1344();
        buffer.method_22918(positionMatrix, 1, -1, 0).method_22915(1f, 1f, 1f, 1f).method_22913(1f, 1f).method_1344();
        buffer.method_22918(positionMatrix, 1, 0, 0).method_22915(1f, 1f, 1f, 1f).method_22913(1f, 0f).method_1344();

        boolean shouldRender = !texture.equals(previous);

        if (shouldRender) {
            profiler.method_15405("draw");
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.disableCull();
            RenderSystem.depthFunc(GL11.GL_ALWAYS);

            class_289.method_1348().method_1350();

            RenderSystem.depthFunc(GL11.GL_LEQUAL);
            RenderSystem.enableCull();
        }

        profiler.method_15407();
    }

    public void renderWorld(WorldRenderContext context) {
        class_3695 worldProfiler = context.profiler();
        worldProfiler.method_15396("sonic");
        worldProfiler.method_15396("world");

        if (client.field_1724 == null)
            return;

        if (isPlayerHoldingSonicOf(SonicMode.Modes.TARDIS) && !TardisServerWorld.isTardisDimension(client.field_1724.method_37908()))
            renderSelectedBlock(context);

        worldProfiler.method_15407();
        worldProfiler.method_15407();
    }

    private void renderSelectedBlock(WorldRenderContext context) {
        class_3695 worldProfiler = context.profiler();
        worldProfiler.method_15396("target");

        if (!(client.field_1765 instanceof class_3965 crosshair)) {
            profiler.method_15407();
            profiler.method_15407();
            return;
        }

        if (client.field_1724 == null || client.field_1687 == null) {
            profiler.method_15407();
            return;
        }

        class_2338 targetPos = crosshair.method_17777();
        class_2680 state = client.field_1687.method_8320(targetPos.method_10074());
        if (state.method_26215()) {
            profiler.method_15407();
            return;
        }

        Tardis tardis = SonicItem.getTardisStatic(client.field_1687, getSonicStack(client.field_1724));

        if (tardis == null) {
            profiler.method_15407();
            return;
        }

        double distance = TardisUtil.distanceFromTardis(client.field_1724, tardis);
        boolean hasEnoughFuel = tardis.fuel().getCurrentFuel() > TardisUtil.estimatedFuelCost(client.field_1724, tardis, distance);

        if(!hasEnoughFuel) {
            renderFloorTexture(targetPos, SELECTED_RED, null, false);
            return;
        }

        renderFloorTexture(targetPos, SELECTED, null, false);

        worldProfiler.method_15407();
        worldProfiler.method_15407();
    }

    public void renderGui(class_332 context, float delta) {
        if (client.field_1687 == null) return;
        if (!isPlayerHoldingScanningSonic()) return;

        profiler.method_15405("sonic");
        profiler.method_15396("gui");

        profiler.method_15396("target");;
        if (!(client.field_1765 instanceof class_3965 crosshair)) {
            profiler.method_15407();
            profiler.method_15407();
            return;
        }
        class_2338 targetPos = crosshair.method_17777();
        class_2680 state = client.field_1687.method_8320(targetPos);

        profiler.method_15405("redstone");
        renderRedstone(context, state, targetPos);
        profiler.method_15405("subsystem_info");
        renderSubSystemInfo(context, targetPos);

        profiler.method_15407();
        profiler.method_15407();
    }

    private void renderRedstone(class_332 context, class_2680 state, class_2338 pos) {
        profiler.method_15396("power");
        renderPower(context, pos);
        profiler.method_15407();
    }

    private void renderPower(class_332 context, class_2338 pos) {
        int power = this.client.field_1687.method_49804(pos);
        if (power == 0) return;

        context.method_25300(client.field_1772, "" + power, getCentreX(), (int) (getMaxY() * 0.4), class_8012.field_42973);
    }

    private void renderSubSystemInfo(class_332 context, class_2338 pos) {
        if (!(client.field_1687.method_8321(pos) instanceof SubSystemBlockEntity be)) return;

        SubSystem system = be.system();
        if (system == null) return;

        class_2561 text = class_2561.method_43473();

        if (system instanceof DurableSubSystem) {
            text = class_2561.method_43470((Math.round(((DurableSubSystem) be.system()).durability())) + " / " + DurableSubSystem.MAX_DURABILITY);
        }
        if (!system.isEnabled() && !(system instanceof EngineSystem)) {
            text = class_2561.method_43471("tardis.message.subsystem.requires_link");
        }

        context.method_27534(client.field_1772, text, getCentreX(), (int) (getMaxY() * 0.42), class_8012.field_42973);

        text = system.name();
        context.method_27534(client.field_1772, text, getCentreX(), (int) (getMaxY() * 0.46), class_8012.field_42973);
    }

    private int getMaxX() {
        return client.method_22683().method_4486();
    }

    private int getMaxY() {
        return client.method_22683().method_4502() ;
    }


    private int getCentreX() {
        return getMaxX() / 2;
    }

    private int getCentreY() {
        return getMaxY() / 2;
    }

    private int getTextWidth(String text) {
        return client.field_1772.method_1727(text);
    }

    private static SonicRendering INSTANCE;

    public static SonicRendering getInstance() {
        if (INSTANCE == null)
            INSTANCE = new SonicRendering();

        return INSTANCE;
    }

    public static boolean isScanningSonic(class_1799 sonic) {
        return isSonicOf(SonicMode.Modes.SCANNING, sonic);
    }

    public static boolean isSonicOf(SonicMode mode, class_1799 sonic) {
        if (sonic.method_7909() instanceof SonicItem)
            return SonicItem.mode(sonic) == mode;

        return false;
    }

    public static boolean isPlayerHoldingScanningSonic() {
        return isPlayerHoldingSonicOf(SonicMode.Modes.SCANNING);
    }

    public static boolean isPlayerHoldingSonicOf(SonicMode mode) {
        class_1657 player = class_310.method_1551().field_1724;

        if (player == null)
            return false;

        class_1799 sonic = getSonicStack(player);

        if (sonic == null)
            return false;

        return isSonicOf(mode, sonic);
    }

    public static class_1799 getSonicStack(class_1657 player) {
        if (player.method_6047().method_7909() instanceof SonicItem)
            return player.method_6047();

        if (player.method_6079().method_7909() instanceof SonicItem)
            return player.method_6079();

        return null;
    }
}
