package dev.amble.ait.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.world.TardisServerWorld;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import org.joml.Matrix4f;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.client.render.*;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.decoration.TardisStarModel;
import dev.amble.ait.core.tardis.Tardis;

public class TardisStar {

    public static final class_2960 TARDIS_STAR_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/environment/eye_of_harmony.png");
    private static final float HALF_SQRT_3 = (float) (Math.sqrt(3.0) / 2.0);

    public static void render(WorldRenderContext context, Tardis tardis) {
        if (DependencyChecker.hasPortals() && !TardisServerWorld.isTardisDimension(context.world()))
            return;

        renderShine(context, tardis);

        renderStar(context, tardis);
        if (!tardis.isGrowth() && !tardis.alarm().isEnabled() && tardis.fuel().hasPower())
            RenderSystem.setShaderFogColor(1, 1, 1, 0);
    }

    public static void renderStar(WorldRenderContext context, Tardis tardis) {
        class_4184 camera = context.camera();
        class_4597 provider = context.consumers();

        class_243 cameraPos = camera.method_19326();
        if (tardis.getDesktop() == null) return;

        class_243 targetPos = new class_243(camera.method_19326().method_10216(),
                context.world().method_31607() - (tardis.isGrowth() ? 150 : 120), camera.method_19326().method_10215());

        class_243 diff = targetPos.method_1020(cameraPos);

        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F));
        matrixStack.method_22904(0, diff.field_1351, 0);
        matrixStack.method_22905(40f, 40f, 40f);

        matrixStack.method_22907(class_7833.field_40716
                .rotationDegrees(((float) class_310.method_1551().field_1724.field_6012 / 200.0f) * 360f));

        TardisStarModel.getTexturedModelData().method_32109().method_22699(matrixStack,
                provider.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(TARDIS_STAR_TEXTURE, true)),
                class_765.field_32767, class_4608.field_21444, tardis.isGrowth() ? 0.1f : 1,
                tardis.isGrowth() ? 0.1f : 1, tardis.isGrowth() ? 0.1f : 1, 0.5f);

        matrixStack.method_22905(0.9f, 0.9f, 0.9f);
        TardisStarModel.getTexturedModelData().method_32109().method_22699(matrixStack,
                provider.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(TARDIS_STAR_TEXTURE, true)),
                class_765.field_32767, class_4608.field_21444, 1, tardis.isGrowth() ? 0.2f : 1,
                tardis.isGrowth() ? 0f : 1, 1f);
    }

    public static void renderShine(WorldRenderContext context, Tardis tardis) {
        if (tardis.getExterior() == null) return;

        if (tardis.isGrowth())
            return;

        class_4587 matrixStack = new class_4587();
        class_4597 provider = context.consumers();

        class_243 cameraPos = context.camera().method_19326();
        class_243 targetPos = new class_243(cameraPos.method_10216(),
                context.world().method_31607() - (tardis.isGrowth() ? 150 : 120), cameraPos.method_10215());

        class_243 diff = targetPos.method_1020(cameraPos);

        float l = (class_310.method_1551().method_1488() / 50120L);
        float sinFunc = (float) Math.sin((class_310.method_1551().field_1724.field_6012 / 400f * 220f) * 0.2f + 0.2f);
        class_5819 random = class_5819.method_43049(432L);
        class_4588 vertexConsumer4 = provider.getBuffer(AITRenderLayers.method_23593());
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(context.camera().method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(context.camera().method_19330() + 180.0F));
        matrixStack.method_22904(0, diff.field_1351, 0);
        if (!tardis.isRefueling())
            matrixStack.method_22905(8, 8, 8);
        else
            matrixStack.method_22905(8 + sinFunc, 8 + sinFunc, 8 + sinFunc);

        matrixStack.method_22907(class_7833.field_40716
                .rotationDegrees(((float) class_310.method_1551().field_1724.field_6012 / -200f) * -560f));

        float m = Math.min(l > 0.8f ? (l - 0.8f) / 0.2f : 0.0f, 1.0f);

        for (int n = 0; n < 30; n++) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees((random.method_43057() * 360.0f)));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees((random.method_43057() * 360.0f)));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees((random.method_43057() * 360.0f)));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees((random.method_43057() * 360.0f)));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees((random.method_43057() * 360.0f)));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees((random.method_43057() * 360.0f + l * 90.0f)));

            float o = random.method_43057() * 10.0f + 10.0f + m * 10.0f;
            float p = random.method_43057() * 0.5f + 1.0f + m * 2.0f;

            Matrix4f matrix4f = matrixStack.method_23760().method_23761();
            int q = (int) (255f * (1.0f - m));

            TardisStar.putDeathLightSourceVertex(tardis, vertexConsumer4, matrix4f, q);
            TardisStar.putDeathLightNegativeXTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightPositiveXTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightSourceVertex(tardis, vertexConsumer4, matrix4f, q);
            TardisStar.putDeathLightPositiveXTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightPositiveZTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightSourceVertex(tardis, vertexConsumer4, matrix4f, q);
            TardisStar.putDeathLightPositiveZTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightNegativeXTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightSourceVertex(tardis, vertexConsumer4, matrix4f, q);
            TardisStar.putDeathLightPositiveZTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
            TardisStar.putDeathLightPositiveZTerminalVertex(tardis, vertexConsumer4, matrix4f, o, p);
        }
    }

    public static void putDeathLightSourceVertex(Tardis tardis, class_4588 buffer, Matrix4f matrix, int alpha) {
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, alpha).method_1344();
    }

    public static void putDeathLightNegativeXTerminalVertex(Tardis tardis, class_4588 buffer, Matrix4f matrix,
                                                            float radius, float width) {
        buffer.method_22918(matrix, -HALF_SQRT_3 * width, radius, -0.5f * width)
                .method_1336(255, tardis.isGrowth() ? 30 : 154, 0, 0).method_1344();
    }

    public static void putDeathLightPositiveXTerminalVertex(Tardis tardis, class_4588 buffer, Matrix4f matrix,
                                                            float radius, float width) {
        buffer.method_22918(matrix, HALF_SQRT_3 * width, radius, -0.5f * width).method_1336(255, tardis.isGrowth() ? 30 : 154, 0, 0)
                .method_1344();
    }

    public static void putDeathLightPositiveZTerminalVertex(Tardis tardis, class_4588 buffer, Matrix4f matrix,
                                                            float radius, float width) {
        buffer.method_22918(matrix, 0.0f, radius, width).method_1336(255, tardis.isGrowth() ? 30 : 154, 0, 0).method_1344();
    }
}
