package dev.amble.ait.client.renderers.consoles;

import org.joml.Matrix4f;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.consoles.ConsoleGeneratorModel;
import dev.amble.ait.client.models.consoles.ConsoleModel;
import dev.amble.ait.core.blockentities.ConsoleGeneratorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;

public class ConsoleGeneratorRenderer<T extends ConsoleGeneratorBlockEntity> implements class_827<T> {

    private final ConsoleGeneratorModel generator;
    private final class_898 dispatcher;

    public static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/consoles/console_generator/console_generator.png");

    private static final int VARIANT_TEXT_COLOR_TURQUOISE = class_5253.class_5254.method_27764(1, 0, 175, 235);
    private static final int VARIANT_TEXT_COLOR_YELLOW = class_5253.class_5254.method_27764(1, 255, 205, 0);

    public ConsoleGeneratorRenderer(class_5614.class_5615 ctx) {
        this.dispatcher = ctx.method_43334();
        this.generator = new ConsoleGeneratorModel(ConsoleGeneratorModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers,
            int light, int overlay) {

        if (ClientConsoleVariantRegistry.getInstance().get(entity.getConsoleVariant().id()) == null)
            return;

        if (entity.method_10997() == null)
            return;

        if (!entity.isLinked())
            return;

        ConsoleModel console = ClientConsoleVariantRegistry.getInstance().get(entity.getConsoleVariant().id()).model();
        class_2960 consoleTexture = ClientConsoleVariantRegistry.getInstance().get(entity.getConsoleVariant().id())
                .texture();
        class_2960 consoleEmission = ClientConsoleVariantRegistry.getInstance().get(entity.getConsoleVariant().id()).emission();

        //boolean powered = entity.isPowered();

        Tardis tardis = entity.tardis().get();

        matrices.method_22903();

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        matrices.method_46416(0.5f, -1.5f, -0.5f);

        this.generator.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580(TEXTURE)), light,
                overlay, 1, 1, 1, 1);

        matrices.method_22909();

        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));

        matrices.method_22904(0.5f, -1.5f + entity.method_10997().field_9229.method_43057() * 0.02, -0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(class_310.method_1551().method_1488() % 180));

        //if (powered) {
            if (tardis.isUnlocked(entity.getConsoleVariant())) {
                console.render(matrices,
                        vertexConsumers.getBuffer(entity.getConsoleVariant().getClient().equals(ClientConsoleVariantRegistry.COPPER) ? class_1921.method_23580(consoleTexture) :
                                class_1921.method_23689(consoleTexture)), 0xf000f0, overlay, 0.3607843137f,
                        0.9450980392f, 1, entity.method_10997().field_9229.method_43048(32) != 6 ? 0.4f : 0.05f);
                if (consoleEmission != null && !consoleEmission.equals(DatapackConsole.EMPTY)) {
                    console.render(matrices,
                            vertexConsumers.getBuffer(entity.getConsoleVariant().getClient().equals(ClientConsoleVariantRegistry.COPPER) ? class_1921.method_23580(consoleTexture) :
                                    class_1921.method_23689(consoleEmission)), 0xf000f0, overlay, 0.3607843137f,
                            0.9450980392f, 1, entity.method_10997().field_9229.method_43048(32) != 6 ? 0.4f : 0.05f);
                }
            } else {
                console.render(matrices,
                        vertexConsumers.getBuffer(entity.getConsoleVariant().getClient().equals(ClientConsoleVariantRegistry.COPPER) ? class_1921.method_23580(consoleTexture) :
                                class_1921.method_23689(consoleTexture)), light,
                        class_4608.field_21444, 0.2f, 0.2f, 0.2f,
                        entity.method_10997().field_9229.method_43048(32) != 6 ? 0.4f : 0.05f);
            }
        //}
        matrices.method_22909();

        matrices.method_22903();
        matrices.method_46416(0.5F, 2.75F, 0.5F);
        matrices.method_22907(this.dispatcher.method_24197());
        matrices.method_22905(-0.1F, -0.1F, 0.1F);

        class_2561 type = class_2561.method_43471("console.ait.variant_label").method_10852(entity.getConsoleVariant().text());
        class_327 textRenderer = class_310.method_1551().field_1772;
        float l = (float) (-textRenderer.method_27525(type) / 2);

        if (/*powered && */!tardis.isUnlocked(entity.getConsoleVariant())) {
            class_2561 text = class_2561.method_43470("\uD83D\uDD12");
            class_2561 requirement = class_2561.method_43470("Requires Loyalty Level: " + (entity.getConsoleVariant().requirement().isPresent() ?
                    entity.getConsoleVariant().requirement().get().type() : "None"));
            float h = (float) (-textRenderer.method_27525(text) / 2);
            float p = (float) (-textRenderer.method_27525(requirement) / 2);

            Matrix4f matrix4f = matrices.method_23760().method_23761();

            textRenderer.method_30882(text, h + 0.35f, 0.0F, 0xFFFFFFFF, false, matrix4f, vertexConsumers,
                    class_327.class_6415.field_33994, 0x000000, 0xf000f0);
            matrices.method_22903();
            matrices.method_22905(0.2f, 0.2f, 0.2f);
            Matrix4f matrixcf = matrices.method_23760().method_23761();
            textRenderer.method_30882(type, l - 0.35f, 42.5F, VARIANT_TEXT_COLOR_TURQUOISE, false, matrixcf, vertexConsumers,
                    class_327.class_6415.field_33994, 0x000000, 0xf000f0);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22905(0.2f, 0.2f, 0.2f);
            Matrix4f matrixdf = matrices.method_23760().method_23761();
            textRenderer.method_30882(requirement, p - 0.35f, 55F, VARIANT_TEXT_COLOR_YELLOW, false, matrixdf, vertexConsumers,
                    class_327.class_6415.field_33994, 0x000000, 0xf000f0);
            matrices.method_22909();
            matrices.method_22909();
        } else {
            matrices.method_22905(0.2f, 0.2f, 0.2f);
            Matrix4f matrixcf = matrices.method_23760().method_23761();
            textRenderer.method_30882(type, l - 0.35f, 42.5F, VARIANT_TEXT_COLOR_YELLOW, false, matrixcf, vertexConsumers,
                    class_327.class_6415.field_33994, 0x000000, 0xf000f0);
            matrices.method_22909();
        }
    }
}
