package dev.amble.ait.client.renderers.consoles;

import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.consoles.ConsoleModel;
import dev.amble.ait.client.models.consoles.HartnellConsoleModel;
import dev.amble.ait.client.models.consoles.SimpleConsoleModel;
import dev.amble.ait.client.models.items.HandlesModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.item.HandlesItem;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.console.ClientConsoleVariantSchema;
import dev.amble.ait.data.schema.console.variant.crystalline.client.ClientCrystallineVariant;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class ConsoleRenderer<T extends ConsoleBlockEntity> implements class_827<T> {

    private ClientConsoleVariantSchema variant;
    private ConsoleModel model;

    public ConsoleRenderer(class_5614.class_5615 ctx) {
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers,
                       int light, int overlay) {

        if (entity.method_10997() == null) return;

        if (!entity.isLinked()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.5, 0.5);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
            HartnellConsoleModel model = new HartnellConsoleModel(HartnellConsoleModel.getTexturedModelData().method_32109());
            model.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23578(ClientConsoleVariantRegistry.HARTNELL.texture())),
                    light, overlay, 1, 1, 1, 1);
            class_1921 layer = AITRenderLayers.tardisEmissiveCullZOffset(ClientConsoleVariantRegistry.HARTNELL.emission(), true);
            model.method_2828(matrices, vertexConsumers.getBuffer(layer),
                    0xf000f0, overlay, 1, 1, 1, 1);
            matrices.method_22909();
            return;
        }

        ClientTardis tardis = entity.tardis().get().asClient();
        class_3695 profiler = entity.method_10997().method_16107();

        this.renderConsole(profiler, tardis, entity, matrices, vertexConsumers, light, overlay, tickDelta);

        if (variant instanceof ClientCrystallineVariant)
            this.renderPanes(tardis, entity, matrices, vertexConsumers, light, overlay);
    }

    private void renderPanes(ClientTardis tardis, T entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!tardis.fuel().hasPower()) return;
        matrices.method_22903();
        matrices.method_22904(1, 2 + entity.method_10997().field_9229.method_43057() * 0.02, 0.5);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(30f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(class_310.method_1551().method_1488() % 180));
        matrices.method_22904(0.58, 0.1, -0.25);
        matrices.method_22905(0.9f, 0.9f, 0.9f);

        class_310.method_1551().method_1480().
                method_23178(new class_1799(class_1802.field_8761),
                        class_811.field_4318, light, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22904(0 + entity.method_10997().field_9229.method_43057() * 0.02, 0 + entity.method_10997().field_9229.method_43057() * 0.02, 0 + entity.method_10997().field_9229.method_43057() * 0.02);
        class_310.method_1551().method_1480().
                method_23178(new class_1799(class_1802.field_8761),
                        class_811.field_4318, light, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22909();

        matrices.method_22903();
        matrices.method_22904(-1, 2 + entity.method_10997().field_9229.method_43057() * 0.02, -0.5);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(30f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(class_310.method_1551().method_1488() % 180));
        matrices.method_22904(0.78, 0.15, -0.11);
        matrices.method_22905(0.9f, 0.9f, 0.9f);

        class_310.method_1551().method_1480().
                method_23178(new class_1799(class_1802.field_8761),
                        class_811.field_4318, light, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22904(0 - entity.method_10997().field_9229.method_43057() * 0.02, 0 + entity.method_10997().field_9229.method_43057() * 0.02, 0 - entity.method_10997().field_9229.method_43057() * 0.02);
        class_310.method_1551().method_1480().
                method_23178(new class_1799(class_1802.field_8761),
                        class_811.field_4318, light, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22909();
    }

    private void renderConsole(class_3695 profiler, ClientTardis tardis, T entity, class_4587 matrices,
                               class_4597 vertexConsumers, int light, int overlay, float tickDelta) {
        profiler.method_15396("model");

        this.updateModel(entity);

        boolean hasPower = tardis.fuel().hasPower();

        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));

        profiler.method_15405("animate");
        model.animateBlockEntity(entity, tardis.travel().getState(), hasPower);

        profiler.method_15405("render");
        model.renderWithAnimations(tardis, entity, model.getPart(),
                matrices, vertexConsumers.getBuffer(variant.equals(ClientConsoleVariantRegistry.COPPER) ? class_1921.method_23580(variant.texture()) :
                        class_1921.method_29379(variant.texture())), light, overlay,
                1, 1, 1, 1, tickDelta);

        this.renderEmissions(profiler, matrices, vertexConsumers, tardis, entity, hasPower, light, overlay, tickDelta);

        matrices.method_22909();
        matrices.method_22903();

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));

        matrices.method_22909();

        profiler.method_15405("monitor");

        if (hasPower && AITModClient.CONFIG.showConsoleMonitorText && model instanceof SimpleConsoleModel simplez) {
            simplez.renderMonitorText(tardis, entity, matrices, vertexConsumers, light, overlay);
        }

        profiler.method_15405("sonic_port"); // } emission / sonic {

        class_1799 stack = entity.getSonicScrewdriver() == null || entity.getSonicScrewdriver().method_7960() ? tardis.butler().getHandles() : entity.getSonicScrewdriver();

        if (stack == null) {
            profiler.method_15407(); // } sonic
            return;
        }

        if (stack.method_7909() instanceof HandlesItem) {
            matrices.method_22903();
            matrices.method_46416(variant.handlesTranslations().x(), variant.handlesTranslations().y(),
                    variant.handlesTranslations().z());
            matrices.method_22907(class_7833.field_40715.rotationDegrees(variant.handlesRotations()[0]));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(variant.handlesRotations()[1]));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            HandlesModel handlesModel = new HandlesModel(HandlesModel.getTexturedModelData().method_32109());
            //handlesModel.setAngles(matrices, ModelTransformationMode.GROUND, false);
            handlesModel.handles.method_32086("stalk").field_3654 = 45f;
            handlesModel.handles.method_32086("stalk").method_32086("head").field_3654 = -0.25f;
            handlesModel.render(null, class_310.method_1551().field_1724, stack, matrices, vertexConsumers, light, overlay, 0);
            matrices.method_22909();
        } else {
            matrices.method_22903();
            matrices.method_46416(variant.sonicItemTranslations().x(), variant.sonicItemTranslations().y(),
                    variant.sonicItemTranslations().z());
            matrices.method_22907(class_7833.field_40715.rotationDegrees(variant.sonicItemRotations()[0]));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(variant.sonicItemRotations()[1]));
            matrices.method_22905(0.9f, 0.9f, 0.9f);
            class_310.method_1551().method_1480().method_23178(stack, class_811.field_4318, light,
                    overlay, matrices, vertexConsumers, entity.method_10997(), 0);
            matrices.method_22909();
        }

        profiler.method_15407(); // } sonic
    }

    private void renderEmissions(class_3695 profiler, class_4587 matrices, class_4597 vertexConsumers, ClientTardis tardis, T entity, boolean hasPower, int light, int overlay, float tickDelta) {
        if (!hasPower) return;

        profiler.method_15405("emission");

        matrices.method_22903();
        if (variant.emission() != null && !variant.emission().equals(DatapackConsole.EMPTY)) {
            model.renderWithAnimations(tardis, entity, model.getPart(),
                    matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(variant.emission(), true)), DependencyChecker.hasIris() ? class_765.field_32767 : light, overlay,
                    1, 1, 1, 1, tickDelta);
        }
        matrices.method_22909();
    }

    private void updateModel(T entity) {
        ClientConsoleVariantSchema variant = entity.getVariant().getClient();

        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.model();
        }
    }

    @Override
    public boolean rendersOutsideBoundingBox(ConsoleBlockEntity consoleBlockEntity) {
        return true;
    }

    @Override
    public int method_33893() {
        return 256;
    }

    @Override
    public boolean isInRenderDistance(ConsoleBlockEntity consoleBlockEntity, class_243 vec3d) {
        return class_243.method_24953(consoleBlockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_24802(vec3d.method_18805(1.0, 0.0, 1.0), this.method_33893());
    }
}
