package dev.amble.ait.client.renderers.coral;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.coral.CoralGrowthModel;
import dev.amble.ait.core.blockentities.CoralBlockEntity;
import dev.amble.ait.core.blocks.CoralPlantBlock;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class CoralRenderer<T extends CoralBlockEntity> implements class_827<T> {

    public static final class_2960 CORAL_GROWTH_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/coral/coral_growth.png");

    private final CoralGrowthModel coralModel;

    public CoralRenderer(class_5614.class_5615 ctx) {
        this.coralModel = new CoralGrowthModel(CoralGrowthModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers,
            int light, int overlay) {
        matrices.method_22903();
        matrices.method_22904(0.5, 0, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        class_2680 blockState = entity.method_11010();
        float f = blockState.method_11654(CoralPlantBlock.FACING).method_10144();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(f));
        class_630 currentAgeModel = getCurrentAge(blockState.method_11654(CoralPlantBlock.AGE), this.coralModel);
        currentAgeModel.method_22699(matrices,
                vertexConsumers.getBuffer(class_1921.method_24293(CORAL_GROWTH_TEXTURE, true)), light,
                overlay, 1, 1, 1, 1);
        matrices.method_22909();
    }

    public class_630 getCurrentAge(int age, CoralGrowthModel coralModel) {
        return switch (age) {
            case 1 -> coralModel.two;
            case 2 -> coralModel.three;
            case 3 -> coralModel.four;
            case 4 -> coralModel.five;
            case 5, 6, 7 -> coralModel.six;
            default -> coralModel.one;
        };
    }
}
