package dev.amble.ait.client.renderers.decoration;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.decoration.PlaqueModel;
import dev.amble.ait.core.blockentities.PlaqueBlockEntity;
import dev.amble.ait.core.blocks.PlaqueBlock;
import dev.amble.ait.core.tardis.Tardis;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class PlaqueRenderer<T extends PlaqueBlockEntity> implements class_827<T> {

    public static final class_2960 PLAQUE_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/decoration/plaque.png"));
    private final class_327 textRenderer = class_310.method_1551().field_1772;
    private final PlaqueModel plaqueModel;

    public PlaqueRenderer(class_5614.class_5615 ctx) {
        this.plaqueModel = new PlaqueModel(PlaqueModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(PlaqueBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {

        class_2680 blockState = entity.method_11010();

        class_2350 k = blockState.method_11654(PlaqueBlock.FACING);

        matrices.method_22903();

        matrices.method_46416(0.5f, 1.5f, 0.5f);

        matrices.method_22907(class_7833.field_40715.rotationDegrees(k.method_10144()));

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        this.plaqueModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580(PLAQUE_TEXTURE)),
                light, overlay, 1.0F, 1.0F, 1.0F, 1.0F);

        matrices.method_22909();

        if (!entity.isLinked() || entity.tardis().isEmpty())
            return;

        Tardis tardis = entity.tardis().get();

        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(k.method_10144()));
        matrices.method_22905(0.01f, 0.01f, 0.01f);
        float xVal = 0;
        matrices.method_46416(xVal, -35f, 35f);

        this.textRenderer.method_37296(class_2561.method_30163(tardis.stats().getCreationString()).method_30937(),
                xVal - ((float) this.textRenderer.method_1727(tardis.stats().getCreationString()) / 2), 35, 0xFFFFFF,
                0x000000, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(entity.getPlaqueText()).method_30937(),
                xVal - ((float) this.textRenderer.method_1727(entity.getPlaqueText()) / 2), 55, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(tardis.stats().getName()).method_30937(),
                xVal - ((float) this.textRenderer.method_1727(tardis.stats().getName()) / 2), 75, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        matrices.method_22909();
    }
}
