package dev.amble.ait.client.renderers.decoration;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.decoration.SnowGlobeModel;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.core.blockentities.SnowGlobeBlockEntity;
import dev.amble.ait.core.blocks.SnowGlobeBlock;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class SnowGlobeRenderer<T extends SnowGlobeBlockEntity> implements class_827<T> {
    public static final class_2960 SNOW_GLOBE_TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/blockentities/decoration/advent/snow_globe.png");

    public static final SnowGlobeModel model = new SnowGlobeModel(SnowGlobeModel.getTexturedModelData().method_32109());

    public SnowGlobeRenderer(class_5614.class_5615 ctx) {}

    @Override
    public void render(SnowGlobeBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22904(0.5, 1.5f, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
        float k = entity.method_11010().method_11654(SnowGlobeBlock.FACING).method_10144();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(k));
        model.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23578(SNOW_GLOBE_TEXTURE)), light, overlay, 1, 1, 1, 1);
        matrices.method_22903();
        matrices.method_22904(0.17, 1.17, -0.2);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(225f));
        matrices.method_22905(0.055f, 0.055f, 0.055f);
        ClientExteriorVariantSchema schema = ClientExteriorVariantRegistry.BOX_DEFAULT;
        ExteriorModel model = schema.model();

        model.render(matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689(schema.texture())), light, overlay, 1, 1, 1, 1);
        model.render(matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(schema.emission(), true)), 0xf000f0, overlay, 1, 1, 1, 1);
        model.render(matrices, vertexConsumers.getBuffer(AITRenderLayers.method_28115(schema.overrides().get(BiomeHandler.BiomeType.SNOWY), false)), light, overlay, 1, 1, 1, 1);

        matrices.method_22909();
        matrices.method_22909();
    }
}
