package dev.amble.ait.client.renderers.doors;

import org.joml.Vector3f;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.boti.BOTI;
import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.models.doors.CapsuleDoorModel;
import dev.amble.ait.client.models.doors.exclusive.DoomDoorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.blocks.DoorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class DoorRenderer<T extends DoorBlockEntity> implements class_827<T> {

    private ClientExteriorVariantSchema variant;
    private AnimatedModel<DoorBlockEntity> model;

    public DoorRenderer(class_5614.class_5615 ctx) {
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers,
                       int light, int overlay) {
        if (entity.method_10997() == null) return;
        if (!entity.isLinked()) {
            class_2680 blockState = entity.method_11010();
            float k = blockState.method_11654(DoorBlock.FACING).method_10144();
            matrices.method_22903();
            matrices.method_22904(0.5, 1.5, 0.5);
            matrices.method_22905(1, 1, 1);
            matrices.method_22907(class_7833.field_40715.rotationDegrees(k + 180));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
            CapsuleDoorModel doorModel = new CapsuleDoorModel(CapsuleDoorModel.getTexturedModelData().method_32109());
            doorModel.method_2828(matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23576(ClientExteriorVariantRegistry.CAPSULE_DEFAULT.texture())),
                    light, overlay, 1, 1, 1, 1);
            matrices.method_22909();
            return;
        }

        class_3695 profiler = entity.method_10997().method_16107();
        profiler.method_15396("door");

        ClientTardis tardis = entity.tardis().get().asClient();
        if (!tardis.siege().isActive())
            this.renderDoor(profiler, tardis, entity, matrices, vertexConsumers, light, overlay, tickDelta);

        profiler.method_15407();
    }

    private void renderDoor(class_3695 profiler, ClientTardis tardis, T entity, class_4587 matrices,
                            class_4597 vertexConsumers, int light, int overlay, float tickDelta) {
        this.updateModel(tardis);

        class_2680 blockState = entity.method_11010();
        float k = blockState.method_11654(DoorBlock.FACING).method_10144();

        class_2960 texture = this.variant.texture();

        if (this.variant.equals(ClientExteriorVariantRegistry.DOOM))
            texture = tardis.door().isOpen() ? DoomDoorModel.DOOM_DOOR_OPEN : DoomDoorModel.DOOM_DOOR;

        matrices.method_22903();
        matrices.method_22904(0.5, 0, 0.5);
        Vector3f scale = tardis.stats().getScale();
        matrices.method_22905(scale.x(), scale.y(), scale.z());
        matrices.method_22907(class_7833.field_40715.rotationDegrees(k));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));

        if (!DependencyChecker.hasIris()) {
            model.renderWithAnimations(tardis, entity, model.getPart(), matrices,
                    vertexConsumers.getBuffer(AITRenderLayers.method_23689(texture)), light, overlay, 1, 1,
                    1, 1, tickDelta);
        }

        /*if (tardis.overgrown().overgrown().get())
            model.renderWithAnimations(entity, model.getPart(), matrices,
                    vertexConsumers.getBuffer(AITRenderLayers.getEntityTranslucentCull(
                            tardis.overgrown().getOvergrownTexture())),
                    light, overlay, 1, 1, 1, 1);*/

        profiler.method_15396("emission");

        class_2960 emissive = this.variant.emission();

        if (!variant.equals(ClientExteriorVariantRegistry.DOOM) && emissive != null && !emissive.equals(DatapackConsole.EMPTY)) {
            boolean power = tardis.fuel().hasPower();
            boolean alarms = tardis.alarm().isEnabled();

            float u;
            float t;
            float s;

            if ((tardis.stats().getName() != null && "partytardis".equals(tardis.stats().getName().toLowerCase()) ||(!tardis.extra().getInsertedDisc().method_7960()))) {
                int m = 25;
                int n = class_310.method_1551().field_1724.field_6012 / m + class_310.method_1551().field_1724.method_5628();
                int o = class_1767.values().length;
                int p = n % o;
                int q = (n + 1) % o;
                float r = ((float)(class_310.method_1551().field_1724.field_6012 % m)) / m;
                float[] fs = class_1472.method_6634(class_1767.method_7791(p));
                float[] gs = class_1472.method_6634(class_1767.method_7791(q));
                s = fs[0] * (1f - r) + gs[0] * r;
                t = fs[1] * (1f - r) + gs[1] * r;
                u = fs[2] * (1f - r) + gs[2] * r;
            } else {
                float[] hs = new float[]{ 1.0f, 1.0f, 1.0f };
                s = hs[0];
                t = hs[1];
                u = hs[2];
            }

            float colorAlpha = 1;

            float red = alarms ? !power ? 0.25f : s : s;
            float green = alarms ? !power ? 0.01f : 0.3f : t;
            float blue = alarms ? !power ? 0.01f : 0.3f : u;

            model.renderWithAnimations(tardis, entity, this.model.getPart(), matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(variant.emission(), true)),
                    0xf000f0, class_4608.field_21444, red, green, blue, colorAlpha, tickDelta);
        }

        if (DependencyChecker.hasIris()) {
            model.renderWithAnimations(tardis, entity, model.getPart(), matrices,
                    vertexConsumers.getBuffer(AITRenderLayers.method_23689(texture)), light, overlay, 1, 1,
                    1, 1, tickDelta);
        }

        profiler.method_15405("biome");

        if (this.variant != ClientExteriorVariantRegistry.CORAL_GROWTH) {
            BiomeHandler biome = tardis.handler(TardisComponent.Id.BIOME);
            class_2960 biomeTexture = biome.getBiomeKey().get(this.variant.overrides());

            if (biomeTexture != null && !texture.equals(biomeTexture)) {
                model.renderWithAnimations(tardis, entity, model.getPart(),
                        matrices, vertexConsumers.getBuffer(AITRenderLayers.method_28116(biomeTexture)),
                        light, overlay, 1, 1, 1, 1, tickDelta);
            }
        }

        if ((tardis.door().getLeftRot() > 0 || this.variant.hasTransparentDoors()) && !tardis.isGrowth())
            BOTI.DOOR_RENDER_QUEUE.add(entity);

        matrices.method_22909();
        profiler.method_15407();
    }

    private void updateModel(Tardis tardis) {
        if (tardis.getExterior().getVariant() == null) return;
        ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();

        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.getDoor().model();
        }
    }

    @Override
    public boolean rendersOutsideBoundingBox(DoorBlockEntity doorBlockEntity) {
        return true;
    }

    @Override
    public int method_33893() {
        return 256;
    }

    @Override
    public boolean isInRenderDistance(DoorBlockEntity doorBlockEntity, class_243 vec3d) {
        return class_243.method_24953(doorBlockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_24802(vec3d.method_18805(1.0, 0.0, 1.0), this.method_33893());
    }
}
