package dev.amble.ait.client.renderers.entities;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.models.exteriors.SiegeModeModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.entities.FallingTardisEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class FallingTardisRenderer extends class_897<FallingTardisEntity> {

    public FallingTardisRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(FallingTardisEntity entity, float yaw, float tickDelta, class_4587 matrices,
            class_4597 vertexConsumers, int light) {
        Tardis tardis = entity.tardis().get();

        if (tardis == null)
            return;

        TardisExterior tardisExterior = tardis.getExterior();
        ClientExteriorVariantSchema exteriorVariant = tardisExterior.getVariant().getClient();

        if (exteriorVariant == null)
            return;

        if (class_310.method_1551().field_1724 == null)
            return;

        class_2960 texture = exteriorVariant.texture();
        class_2960 emission = exteriorVariant.emission();
        ExteriorModel model = exteriorVariant.model();

        if (model == null)
            return;

        matrices.method_22903();
        int k = entity.getBlockState().method_11654(ExteriorBlock.ROTATION);
        float h = class_7718.method_45482(k);

        matrices.method_22907(
                class_7833.field_40715.rotationDegrees(!exteriorVariant.equals(ClientExteriorVariantRegistry.DOOM)
                        ? 180f + h
                        : class_310.method_1551().field_1724.method_5791() + 180f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));

        boolean siege = tardis.siege().isActive();

        if (siege) {
            model = new SiegeModeModel(SiegeModeModel.getTexturedModelData().method_32109());
            texture = tardis.siege().texture().get();
        }

        model.renderEntity(entity, model.getPart(), matrices,
                vertexConsumers.getBuffer(AITRenderLayers.method_23689(texture)), light,
                class_4608.field_21444, 1, 1, 1, 1);

        if (siege) {
            matrices.method_22909();
            return;
        }

        if (emission != null)
            model.renderEntity(entity, model.getPart(), matrices,
                    vertexConsumers.getBuffer(DependencyChecker.hasIris() ? AITRenderLayers.tardisEmissiveCullZOffset(emission, true) : AITRenderLayers.method_23028(emission)),
                    0xf000f0, class_4608.field_21444, 1, 1, 1, 1);

        if (!exteriorVariant.equals(ClientExteriorVariantRegistry.CORAL_GROWTH)) {
            BiomeHandler handler = tardis.handler(TardisComponent.Id.BIOME);
            class_2960 biomeTexture = handler.getBiomeKey().get(exteriorVariant.overrides());

            if (biomeTexture != null && !exteriorVariant.texture().equals(biomeTexture)) {
                model.renderEntity(entity, model.getPart(), matrices,
                        vertexConsumers.getBuffer(AITRenderLayers.method_23689(biomeTexture)), light,
                        class_4608.field_21444, 1, 1, 1, 1);
            }
        }

        matrices.method_22909();
    }

    @Override
    public class_2960 getTexture(FallingTardisEntity entity) {
        if (entity.tardis().get() == null)
            return class_1059.field_5275; // random texture just so i dont crash

        return entity.tardis().get().getExterior().getVariant().getClient().texture();
    }
}
