package dev.amble.ait.client.renderers.entities;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.models.machines.ShieldsModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.renderers.VortexRender;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class FlightTardisRenderer extends class_897<FlightTardisEntity> {

    private ExteriorModel model;
    private ClientExteriorVariantSchema variant;

    public FlightTardisRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(FlightTardisEntity entity, float yaw, float tickDelta, class_4587 matrices,
            class_4597 vertexConsumers, int light) {
        if (!entity.isLinked())
            return;

        Tardis tardis = entity.tardis().get();

        if (tardis == null) return;

        this.updateModel(tardis);

        if (entity.method_5642() == null ||
                !(entity.method_5642() instanceof class_742 player)) return;

        if (player.method_5854() == null || player.method_5854() != entity) return;

        class_243 vec3d = entity.method_5828(tickDelta);
        class_243 vec3d2 = entity.lerpVelocity(tickDelta);

        double d = vec3d2.method_37268();
        double e = vec3d.method_37268();

        matrices.method_22903();
        if (tardis.door().isClosed() && !entity.field_36331)
            matrices.method_22904(0, 0.25f * -vec3d2.method_10214(), 0);

        if (tardis.travel().position().getDimension() == AITDimensions.TIME_VORTEX_WORLD) {
            VortexRender vortexRender = tardis.stats().getVortexEffects().toRender();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float) class_310.method_1551().field_1724.field_6012 / 100 * 360f));
            matrices.method_46416(0, 0, 500);
            vortexRender.render(matrices);
            matrices.method_22909();
        }

        if (d > 0.0 && e > 0.0) {
            double l = (vec3d2.field_1352 * vec3d.field_1352 + vec3d2.field_1350 * vec3d.field_1350) / Math.sqrt(d * e);
            double m = vec3d2.field_1352 * vec3d.field_1350 - vec3d2.field_1350 * vec3d.field_1352;
            double v = Math.signum(m) * Math.acos(l);
            matrices.method_22907(class_7833.field_40716.rotation((float) v));
        }

        boolean doorsClosed = tardis.door().isClosed();
        float deg = doorsClosed ? (float) (d * 22.5f) : (float) -d * 22.5f;

        if (!entity.field_5992 && !doorsClosed) {
            this.model.getPart().method_33425((float) 0, 0, 0);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180f));
        } else if (!entity.field_5992) {
            this.model.getPart().method_33425((float) 0, ((entity.getRotation(tickDelta)) * tardis.travel().speed()), 0);
        }

        /*if (!entity.verticalCollision)
            matrices.multiply(RotationAxis.POSITIVE_X.rotationDegrees((float) (2f * Math.cos(0.2f * (tickDelta + entity.age))) + deg));*/

        matrices.method_22907(class_7833.field_40718.rotationDegrees(entity.field_5992 ? 180f : (float) (2f * Math.sin(0.2f * (tickDelta + entity.field_6012)) + 180f)));

        this.model.renderEntity(entity, this.model.getPart(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689(getTexture(entity))), light, class_4608.field_21444, 1, 1, 1, 1);

        if (variant.emission() != null && tardis.fuel().hasPower()) {
            boolean alarms = tardis.alarm().isEnabled();

            float color = alarms ? 0.3f : 1f;

            model.renderEntity(entity, this.model.getPart(), matrices, vertexConsumers.getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(variant.emission(), true)), 0xf000f0, class_4608.field_21444, color, color, color, 1);
        }

        BiomeHandler biome = tardis.handler(TardisComponent.Id.BIOME);
        class_2960 biomeTexture = biome.getBiomeKey().get(variant.overrides());

        if (biomeTexture != null && !this.getTexture(entity).equals(biomeTexture))
            model.renderEntity(entity, this.model.getPart(), matrices, vertexConsumers.getBuffer(AITRenderLayers.method_23689(biomeTexture)), light, class_4608.field_21444, 1, 1, 1, 1);

        int maxLight = 0xF000F0;

        matrices.method_22909();
        if (tardis.areVisualShieldsActive()) {
            matrices.method_22903();

            float delta = ((tickDelta + entity.field_6012) * 0.03f);
            ShieldsModel shieldsModel = new ShieldsModel(ShieldsModel.getTexturedModelData().method_32109());
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23018(new class_2960("textures/misc/forcefield.png"), delta % 1.0F, (delta * 0.1F) % 1.0F));
            shieldsModel.method_2828(matrices, vertexConsumer, maxLight, class_4608.field_21444, 0f, 0.25f, 0.5f, 1f);
            matrices.method_22909();
        }
    }

    private ExteriorModel getModel(Tardis tardis) {
        if (model == null)
            model = tardis.getExterior().getVariant().getClient().model();

        return model;
    }

    @Override
    public class_2960 getTexture(FlightTardisEntity entity) {
        if (!entity.isLinked())
            return class_1059.field_5275; // random texture just so i dont crash

        return entity.tardis().get().getExterior().getVariant().getClient().texture();
    }

    private void updateModel(Tardis tardis) {
        ClientExteriorVariantSchema variant = tardis.getExterior().getVariant().getClient();

        if (this.variant != variant) {
            this.variant = variant;
            this.model = variant.model();
        }
    }
}
