package dev.amble.ait.client.renderers.machines;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.machines.ArtronCollectorModel;
import dev.amble.ait.core.blockentities.ArtronCollectorBlockEntity;
import dev.amble.ait.core.blocks.ArtronCollectorBlock;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

// Made with Blockbench 4.8.3
// Exported for Minecraft version 1.17+ for Yarn
// Paste this class into your mod and generate all required imports
public class ArtronCollectorRenderer<T extends ArtronCollectorBlockEntity> implements class_827<T> {

    public static final class_2960 COLLECTOR_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/machines/artron_collector.png"));
    public static final class_2960 EMISSIVE_COLLECTOR_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/machines/artron_collector_emission.png"));
    private final ArtronCollectorModel artronCollectorModel;

    public ArtronCollectorRenderer(class_5614.class_5615 ctx) {
        this.artronCollectorModel = new ArtronCollectorModel(ArtronCollectorModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(ArtronCollectorBlockEntity entity, float tickDelta, class_4587 matrices,
            class_4597 vertexConsumers, int light, int overlay) {

        class_2680 blockState = entity.method_11010();

        float f = blockState.method_11654(ArtronCollectorBlock.FACING).method_10144();

        if (class_310.method_1551().field_1687 == null)
            return;

        matrices.method_22903();

        matrices.method_46416(0.5f, 1.5f, 0.5f);

        matrices.method_22907(class_7833.field_40715.rotationDegrees(f));

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        class_630 batteryLevels = artronCollectorModel.collector.method_32086("battery_levels");

        artronCollectorModel.collector.method_32086("spinner").field_3675 = entity.getCurrentFuel() > 0
                ? ((float) class_310.method_1551().field_1687.method_8510() / 12000L) * 180.0f
                : 0;

        batteryLevels.method_32086("b_1").field_3665 = entity.getCurrentFuel() > 250 && entity.getCurrentFuel() < 500;
        batteryLevels.method_32086("b_2").field_3665 = entity.getCurrentFuel() > 500 && entity.getCurrentFuel() < 750;
        batteryLevels.method_32086("b_3").field_3665 = entity.getCurrentFuel() > 750 && entity.getCurrentFuel() < 1000;
        batteryLevels.method_32086("b_4").field_3665 = entity.getCurrentFuel() > 1000 && entity.getCurrentFuel() < 1250;
        batteryLevels.method_32086("b_5").field_3665 = entity.getCurrentFuel() > 1250 && entity.getCurrentFuel() < 1500;
        batteryLevels.method_32086("b_6").field_3665 = entity.getCurrentFuel() == 1500;

        this.artronCollectorModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_23580(COLLECTOR_TEXTURE)), light, overlay, 1.0F,
                1.0F, 1.0F, 1.0F);
        this.artronCollectorModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_42600(EMISSIVE_COLLECTOR_TEXTURE)),
                0xF000F00, overlay, 1.0F, 1.0F, 1.0F, 1.0F);

        matrices.method_22909();
    }
}
