package dev.amble.ait.client.renderers.machines;

import org.joml.Vector3f;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.machines.EngineModel;
import dev.amble.ait.core.blockentities.EngineBlockEntity;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.tardis.Tardis;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;

// Made with Blockbench 4.8.3
// Exported for Minecraft version 1.17+ for Yarn
// Paste this class into your mod and generate all required imports
public class EngineRenderer<T extends EngineBlockEntity> implements class_827<T> {

    public static final class_2960 ENGINE_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/machines/engine.png"));
    public static final class_2960 EMISSIVE_ENGINE_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/machines/engine_emission.png"));
    private final EngineModel engineModel;

    public EngineRenderer(class_5614.class_5615 ctx) {
        this.engineModel = new EngineModel(EngineModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(EngineBlockEntity entity, float tickDelta, class_4587 matrices,
            class_4597 vertexConsumers, int light, int overlay) {

        if (!entity.isLinked())
            return;

        Tardis tardis = entity.tardis().get();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40713.rotationDegrees(180));
        matrices.method_22904(0.5, -0.867f, -0.5);

        this.engineModel.render(tardis, matrices, vertexConsumers.getBuffer(class_1921.method_23578(ENGINE_TEXTURE)),
                class_765.method_23687(entity.method_10997().method_8314(class_1944.field_9282, entity.method_11016().method_10084()), entity.method_10997().method_8314(class_1944.field_9284, entity.method_11016())), overlay, 1.0F, 1.0F, 1.0F, 1.0F);

        if (tardis.fuel().hasPower()) {
            EngineSystem.Status status = tardis.subsystems().engine().status();
            Vector3f colours = status.colour;
            this.engineModel.render(tardis, matrices, vertexConsumers.getBuffer
                            (class_1921.method_28115(EMISSIVE_ENGINE_TEXTURE, true)),
                    0xf000f0,
                    overlay, colours.x, colours.y, colours.z, (status !=
                            EngineSystem.Status.OFF) ? 1.0F : 0.0F);
        }

        matrices.method_22909();
    }
}
