package dev.amble.ait.client.renderers.machines;

import org.joml.Vector3f;
import dev.amble.ait.client.models.machines.GenericSubSystemModel;
import dev.amble.ait.client.renderers.MultiBlockStructureRenderer;
import dev.amble.ait.core.engine.StructureHolder;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.generic.GenericStructureSystemBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class GenericSubSystemRenderer<T extends GenericStructureSystemBlockEntity> implements class_827<T> {
    private GenericSubSystemModel model;

    public GenericSubSystemRenderer(class_5614.class_5615 ctx) {
        this.model = new GenericSubSystemModel();
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices,
                       class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();

        SubSystem system = entity.system();
        if (entity.hasSystem() && system != null && !system.isUsable() && system instanceof StructureHolder holder) {
            MultiBlockStructureRenderer.instance().render(holder.getStructure(), entity.method_11016(), entity.method_10997(), matrices, vertexConsumers, true);
        }

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
        matrices.method_46416(0.5f, -1.5f, -0.5f);

        class_1799 stack = entity.getSourceStack().orElse(null);
        boolean hasStack = stack != null && !stack.method_7960();

        class_630 wires = this.model.method_32008().method_32086("wires");
        wires.field_3665 = hasStack;

        this.model.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580(GenericSubSystemModel.TEXTURE)),
                light, overlay, 1.0F, 1.0F, 1.0F, 1.0F);

        if (hasStack) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
            double offset = Math.sin((entity.method_10997().method_8510() + tickDelta) / 8.0) / 18.0;

            matrices.method_22904(0, -1.15f + (offset / 2), 0);

            Vector3f scale = class_310.method_1551().method_1480().method_4019(stack, entity.method_10997(), null, 0).method_4709().field_4304.field_4285;
            matrices.method_22905(0.9f, 0.9f, 0.9f);
            matrices.method_22905(scale.x, scale.y, scale.z);

            class_310.method_1551().method_1480().method_23178(stack, class_811.field_4318, light,
                    overlay, matrices, vertexConsumers, entity.method_10997(), 0);
            matrices.method_22909();
        }

        matrices.method_22909();
    }
}
