package dev.amble.ait.client.renderers.machines;

import dev.amble.lib.data.DirectedGlobalPos;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.util.ClientItemUtil;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.blockentities.WaypointBankBlockEntity;
import dev.amble.ait.core.blocks.WaypointBankBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.WorldUtil;

public class WaypointBankBlockEntityRenderer<T extends WaypointBankBlockEntity> implements class_827<T> {

    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final String SEPARATOR = "------------";

    private static final class_1091 WAYPOINT = new class_1091(AITMod.MOD_ID,
            class_7923.field_41178.method_10221(AITItems.WAYPOINT_CARTRIDGE).method_12832(), "inventory");

    public WaypointBankBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light,
            int overlay) {
        if (!entity.isLinked())
            return;

        Tardis tardis = entity.tardis().get();

        if (!tardis.fuel().hasPower())
            return;

        float facing = entity.method_11010().method_11654(WaypointBankBlock.FACING).method_10144();

        WaypointBankBlockEntity.WaypointData[] waypoints = entity.getWaypoints();
        int selectedIndex = entity.getSelected();

        if (selectedIndex != -1)
            renderMonitor(matrices, vertices, facing, waypoints, selectedIndex);

        class_1087 cartridgeModel = WaypointBankBlockEntityRenderer.cartridgeModel();
        int i = 0;

        matrices.method_22903();

        matrices.method_46416(0.5f, 2, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-facing));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90f));
        matrices.method_22904(-0.0625f * 11.5, 0.0625 * 5, 0.0625f * 5.5);

        matrices.method_22903();
        for (; i < WaypointBankBlock.MAX_COUNT / 2; i++) {
            renderCartridge(matrices, vertices, light, overlay, cartridgeModel, waypoints, selectedIndex, i);
        }
        matrices.method_22909();

        matrices.method_22903();
        matrices.method_46416(0.0625f * 7, 0, 0);

        for (; i < WaypointBankBlock.MAX_COUNT; i++) {
            renderCartridge(matrices, vertices, light, overlay, cartridgeModel, waypoints, selectedIndex, i);
        }

        matrices.method_22909();

        matrices.method_22909();
    }

    private static void renderLabel(class_4587 matrices, class_4597 vertexConsumers, String text, int y) {
        textRenderer.method_27521(text, 0 - ((float) textRenderer.method_1727(text) / 2), y, 0x00F0FF, false,
                matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0xF000F0,
                0xF000F0);
    }

    private static void renderLabel(class_4587 matrices, class_4597 vertexConsumers, class_5481 text,
            int y) {
        textRenderer.method_22942(text, 0 - ((float) textRenderer.method_30880(text) / 2), y, 0x00F0FF, false,
                matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0xF000F0,
                0xF000F0);
    }

    private static void renderMonitor(class_4587 matrices, class_4597 vertices, float facing,
            WaypointBankBlockEntity.WaypointData[] data, int selectedIndex) {
        WaypointBankBlockEntity.WaypointData selected = data[selectedIndex];

        if (selected == null)
            return;

        DirectedGlobalPos abpd = selected.pos();

        int rotation = abpd.getRotation();
        class_2338 abpdPos = abpd.getPos();

        String destPos = abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        String destDim = WorldUtil.worldText(abpd.getDimension(), false).getString();

        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(facing));

        matrices.method_22905(0.01f, 0.01f, 0.01f);
        matrices.method_46416(0f, -142f, -51f);

        renderLabel(matrices, vertices, selected.name(), 35);

        renderLabel(matrices, vertices, SEPARATOR, 46);
        renderLabel(matrices, vertices, destPos, 55);

        renderLabel(matrices, vertices, WorldUtil.rot2Text(rotation).method_30937(), 67);
        renderLabel(matrices, vertices, destDim, 78);

        String which = (selectedIndex + 1) + "/" + WaypointBankBlock.MAX_COUNT;
        renderLabel(matrices, vertices, which, 96);
        matrices.method_22909();
    }

    private static void renderCartridge(class_4587 matrices, class_4597 vertices, int light, int overlay,
            class_1087 model, WaypointBankBlockEntity.WaypointData[] data, int selected, int current) {
        matrices.method_46416(0, 0, 0.0625f * 2);
        WaypointBankBlockEntity.WaypointData waypoint = data[current];

        if (waypoint == null)
            return;

        if (current == selected) {
            matrices.method_22903();
            matrices.method_46416(0, 0.0625f * 2, 0);
            ClientItemUtil.renderBakedItemModel(model, waypoint.color(), 0x0F000F0, overlay, matrices, vertices);
            matrices.method_22909();
        } else {
            ClientItemUtil.renderBakedItemModel(model, waypoint.color(), light, overlay, matrices, vertices);
        }
    }

    private static class_1087 cartridgeModel() {
        return class_310.method_1551().method_1554().method_4742(WAYPOINT);
    }
}
