package dev.amble.ait.client.renderers.monitors;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2484;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.models.monitors.CRTMonitorModel;
import dev.amble.ait.core.blockentities.MonitorBlockEntity;
import dev.amble.ait.core.blocks.MonitorBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.MonitorStateUtil;
import dev.amble.ait.core.util.MonitorUtil;
import dev.amble.ait.core.util.WorldUtil;

public class MonitorRenderer<T extends MonitorBlockEntity> implements class_827<T> {


    private static final class_2960 MONITOR_TEXTURE_DEFAULT = new class_2960(AITMod.MOD_ID, "textures/blockentities/monitors/crt_monitor.png");
    private static final class_2960 MONITOR_TEXTURE_BLAZE = new class_2960(AITMod.MOD_ID, "textures/blockentities/monitors/crt_monitor/blaze.png");
    public static final class_2960 EMISSIVE_MONITOR_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/monitors/crt_monitor_emission.png"));
    private final class_327 textRenderer = class_310.method_1551().field_1772;
    private final CRTMonitorModel crtMonitorModel;

    public MonitorRenderer(class_5614.class_5615 ctx) {
        this.crtMonitorModel = new CRTMonitorModel(CRTMonitorModel.getTexturedModelData().method_32109());
    }


    @Override
    public void render(MonitorBlockEntity entity, float tickDelta, class_4587 matrices,
                       class_4597 vertexConsumers, int light, int overlay) {

        MonitorStateUtil state = entity.method_11010().method_11654(MonitorBlock.TEXTURE);

        class_2960 texture = switch (state) {
            case BLAZE -> MONITOR_TEXTURE_BLAZE;
            default -> MONITOR_TEXTURE_DEFAULT;
        };

        class_2680 blockState = entity.method_11010();

        int k = blockState.method_11654(class_2484.field_11505);
        float h = class_7718.method_45482(k);

        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(h));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        this.crtMonitorModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_23580(texture)), light, overlay, 1.0F,
                1.0F, 1.0F, 1.0F);
        if (state == MonitorStateUtil.DEFAULT) {
            this.crtMonitorModel.method_2828(matrices,
                    vertexConsumers.getBuffer(class_1921.method_42600(EMISSIVE_MONITOR_TEXTURE)),
                    0xF000F00, overlay, 1.0F, 1.0F, 1.0F, 1.0F);
        }
        matrices.method_22909();

        if (!entity.isLinked())
            return;

        Tardis tardis = entity.tardis().get();

        if (!tardis.fuel().hasPower())
            return;

        if (!AITModClient.CONFIG.showCRTMonitorText)
            return;

        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(180 - h));
        matrices.method_22905(0.005f, 0.005f, 0.005f);
        matrices.method_46416(-50f, 0, -80);

        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos abpp = travel.isLanded() || travel.getState() == TravelHandlerBase.State.MAT
                ? travel.position()
                : travel.getProgress();

        class_2338 abppPos = abpp.getPos();

        CachedDirectedGlobalPos abpd = tardis.travel().destination();
        class_2338 abpdPos = abpd.getPos();

        String positionPosText = " " + abppPos.method_10263() + ", " + abppPos.method_10264() + ", " + abppPos.method_10260();
        class_2561 positionDimensionText = class_2561.method_30163(MonitorUtil.truncateDimensionName(WorldUtil.worldText(abpp.getDimension()).getString(), 20));

        this.textRenderer.method_37296(class_2561.method_30163("❌").method_30937(), 0, 0, 0xF00F00, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(positionPosText).method_30937(), 0, 8, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(positionDimensionText.method_30937(), 0, 16, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(WorldUtil.rot2Text(abpp.getRotation()).method_30937(), 0, 24, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        String destinationPosText = " " + abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 destinationDimensionText = class_2561.method_30163(MonitorUtil.truncateDimensionName(WorldUtil.worldText(abpd.getDimension(), false).getString(), 20));


        this.textRenderer.method_37296(class_2561.method_30163("✛").method_30937(), 0, 40, 0x00F0FF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(destinationPosText).method_30937(), 0, 48, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(destinationDimensionText.method_30937(), 0, 56, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(WorldUtil.rot2Text(abpd.getRotation()).method_30937(), 0, 64, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        String fuelText = Math.round((tardis.getFuel() / FuelHandler.TARDIS_MAX_FUEL) * 100) + "%";
        this.textRenderer.method_37296(class_2561.method_30163("⛽").method_30937(), 0, 78, 0xFAF000, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(fuelText).method_30937(), 8, 78, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        String flightTimeText = tardis.travel().getState() == TravelHandlerBase.State.LANDED
                ? "0%"
                : tardis.travel().getDurationAsPercentage() + "%";
        this.textRenderer.method_37296(class_2561.method_30163("⏳").method_30937(), 0, 92, 0x00FF0F, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(flightTimeText).method_30937(), 8, 92, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        String name = tardis.stats().getName();
        this.textRenderer.method_37296(class_2561.method_30163(name).method_30937(), 98 - (this.textRenderer.method_1727(name)), 90,
                0xFFFFFF, 0x000000, matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        if (tardis.alarm().isEnabled())
            this.textRenderer.method_37296(class_2561.method_30163("⚠").method_30937(), 84, 0, 0xFE0000, 0x000000,
                    matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        matrices.method_22909();
    }
}