package dev.amble.ait.client.renderers.monitors;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.decoration.PlaqueModel;
import dev.amble.ait.core.blockentities.WallMonitorBlockEntity;
import dev.amble.ait.core.blocks.PlaqueBlock;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.WorldUtil;

public class WallMonitorRenderer<T extends WallMonitorBlockEntity> implements class_827<T> {

    public static final class_2960 PLAQUE_TEXTURE = new class_2960(AITMod.MOD_ID,
            ("textures/blockentities/monitors/wall_monitor.png"));
    private final class_327 textRenderer = class_310.method_1551().field_1772;
    private final PlaqueModel plaqueModel;

    public WallMonitorRenderer(class_5614.class_5615 ctx) {
        this.plaqueModel = new PlaqueModel(PlaqueModel.getTexturedModelData().method_32109());
    }

    private String truncateDimensionName(String name, int maxLength) {
        if (name.length() > maxLength) {
            return name.substring(0, maxLength) + "...";
        }
        return name;
    }

    @Override
    public void render(WallMonitorBlockEntity entity, float tickDelta, class_4587 matrices,
            class_4597 vertexConsumers, int light, int overlay) {
        class_2680 blockState = entity.method_11010();

        class_2350 k = blockState.method_11654(PlaqueBlock.FACING);

        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(k.method_10144()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        this.plaqueModel.method_2828(matrices, vertexConsumers.getBuffer(class_1921.method_23580(PLAQUE_TEXTURE)),
                light, overlay, 1.0F, 1.0F, 1.0F, 1.0F);
        matrices.method_22909();

        if (!entity.isLinked())
            return;

        Tardis tardis = entity.tardis().get();

        if (!tardis.fuel().hasPower())
            return;

        matrices.method_22903();
        matrices.method_22904(0.5, 0.75, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(k.method_10144()));
        matrices.method_22905(0.01f, 0.01f, 0.01f);
        float xVal = 0f;
        matrices.method_46416(xVal, -35f, 35f);

        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos abpp = travel.isLanded() || travel.getState() == TravelHandlerBase.State.MAT
                ? travel.position()
                : travel.getProgress();

        class_2338 abppPos = abpp.getPos();

        CachedDirectedGlobalPos abpd = tardis.travel().destination();
        class_2338 abpdPos = abpd.getPos();

        String positionPosText = abppPos.method_10263() + ", " + abppPos.method_10264() + ", " + abppPos.method_10260();
        class_2561 positionDimensionText = class_2561.method_30163(truncateDimensionName(WorldUtil.worldText(abpp.getDimension()).getString(), 16));

        String fuelText = Math.round((tardis.getFuel() / FuelHandler.TARDIS_MAX_FUEL) * 100) + "%";

        String destinationPosText = abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 destinationDimensionText = class_2561.method_30163(truncateDimensionName(WorldUtil.worldText(abpd.getDimension(), false).getString(), 16));


        float v = -20f;

        String arrow = DirectionControl.rotationForArrow(abpp.getRotation());
        String arrow2 = DirectionControl.rotationForArrow(abpd.getRotation());

        this.textRenderer.method_37296(class_2561.method_30163(positionPosText).method_30937(),
                (v - xVal) - ((float) this.textRenderer.method_1727(positionPosText) / 2), 35, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(positionDimensionText.method_30937(),
                (v - xVal) - ((float) this.textRenderer.method_27525(positionDimensionText) / 2), 46, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(arrow).method_30937(),
                (18 - xVal) - ((float) this.textRenderer.method_1727(arrow) / 2), 42, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163("-===========-").method_30937(),
                (v - xVal) - ((float) this.textRenderer.method_1727("-===========-") / 2), 55, 0x00F0FF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(destinationPosText).method_30937(),
                (v - xVal) - ((float) this.textRenderer.method_1727(destinationPosText) / 2), 67, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(destinationDimensionText.method_30937(),
                (v - xVal) - ((float) this.textRenderer.method_27525(positionDimensionText) / 2), 78, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(arrow2).method_30937(),
                (18 - xVal) - ((float) this.textRenderer.method_1727(arrow2) / 2), 75, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        this.textRenderer.method_37296(class_2561.method_30163("⛽").method_30937(),
                (53 - xVal) - ((float) this.textRenderer.method_1727("⛽") / 2), 40, 0xFAF000, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(fuelText).method_30937(),
                (53 - xVal) - ((float) this.textRenderer.method_1727(fuelText) / 2), 48, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        String flightTimeText = travel.getState() == TravelHandlerBase.State.LANDED
                ? "0%"
                : tardis.travel().getDurationAsPercentage() + "%";

        this.textRenderer.method_37296(class_2561.method_30163("⏳").method_30937(),
                (53 - xVal) - ((float) this.textRenderer.method_1727("⏳") / 2), 60, 0x00FF0F, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);
        this.textRenderer.method_37296(class_2561.method_30163(flightTimeText).method_30937(),
                (53 - xVal) - ((float) this.textRenderer.method_1727(flightTimeText) / 2), 68, 0xFFFFFF, 0x000000,
                matrices.method_23760().method_23761(), vertexConsumers, 0xF000F0);

        matrices.method_22909();
    }
}
