package dev.amble.ait.client.screens;

import java.util.List;
import java.util.function.Consumer;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7077;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.client.screens.widget.SwitcherManager;
import dev.amble.ait.core.blocks.AstralMapBlock;
import dev.amble.ait.core.util.WorldUtil;

public class AstralMapScreen extends class_437 {

    private static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/security_menu.png");
    int bgHeight = 138;
    int bgWidth = 216;
    int left, top;
    final IdentifierSwitcher switcher;

    public AstralMapScreen() {
        super(class_2561.method_43471("screen." + AITMod.MOD_ID + ".astral_map"));

        this.field_22787 = class_310.method_1551();

        this.switcher = new IdentifierSwitcher(AstralMapBlock.structureIds, (id) -> {
            ClientPlayNetworking.send(AstralMapBlock.REQUEST_SEARCH, PacketByteBufs.create().method_10812(id));
            this.method_25419();
        });
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        this.top = (this.field_22790 - this.bgHeight) / 2; // this means everythings centered and scaling, same for below
        this.left = (this.field_22789 - this.bgWidth) / 2;

        super.method_25426();

         this.method_37063(new class_7077((field_22789 / 2 - 30), (field_22790 / 2 + 12),
                this.field_22793.method_1727("<"), 10, class_2561.method_43470("<"), button -> this.switcher.previous(), this.field_22793));
        this.method_37063(new class_7077((field_22789 / 2 + 25), (field_22790 / 2 + 12),
                this.field_22793.method_1727(">"), 10, class_2561.method_43470(">"), button -> this.switcher.next(), this.field_22793));
        this.method_37063(new class_7077((field_22789 / 2 - this.field_22793.method_27525(class_2561.method_43470("SEARCH")) / 2), (field_22790 / 2 + 12),
                this.field_22793.method_27525(class_2561.method_43470("SEARCH")), 10, class_2561.method_43470("SEARCH"), button -> this.switcher.sync(null), this.field_22793));
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);

        super.method_25394(context, mouseX, mouseY, delta);

        class_2561 currentText = class_2561.method_43470(switcher.get().name().toUpperCase());
        context.method_51439(this.field_22793, currentText, (int) (left + (bgWidth * 0.5f)) - this.field_22793.method_27525(currentText) / 2,
                (int) (top + (bgHeight * 0.5)), 0xffffff, true);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(TEXTURE, left, top, 0, 0, bgWidth, bgHeight);
    }

    record IdentifierToName(class_2960 id) implements Nameable {
        @Override
        public String name() {
            try {
                return WorldUtil.fakeTranslate(id.method_12832());
            } catch (Exception e) {
                return id.toString();
            }
        }
    }

    static class IdentifierSwitcher extends SwitcherManager<IdentifierToName, class_2960> {
        public IdentifierSwitcher(List<class_2960> list, Consumer<class_2960> sync) {
            super((var) -> next(var, list), (var) -> prev(var, list), (var, arg) -> {sync.accept(var.id());}, new IdentifierToName(list.get(0)), "identifier");
        }

        private static IdentifierToName next(IdentifierToName id, List<class_2960> list) {
            int idx =  list.indexOf(id.id());
            idx = (idx + 1) % list.size();
            return new IdentifierToName(list.get(idx));
        }

        private static IdentifierToName prev(IdentifierToName id, List<class_2960> list) {
            int idx = list.indexOf(id.id());
            idx = (idx - 1 + list.size()) % list.size();
            return new IdentifierToName(list.get(idx));
        }
    }
}
