package dev.amble.ait.client.screens;


import org.jetbrains.annotations.Nullable;
import dev.amble.ait.client.sounds.PlayerFollowingLoopingSound;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.AITSounds;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

/**
 * A screen that is opened from a console.
 * It also plays idle sfx. see {@link #shouldPlayIdleSfx()} and {@link #getIdleSound()}
 */
public abstract class ConsoleScreen extends TardisScreen {

    protected final class_2338 console;
    protected static PlayerFollowingLoopingSound idleSound;

    protected ConsoleScreen(class_2561 title, ClientTardis tardis, class_2338 console) {
        super(title, tardis);

        this.field_22787 = class_310.method_1551();
        this.console = console;

        boolean hasChanged = idleSound == null || idleSound.method_4775() != this.getIdleSound().method_14833();

        if (hasChanged) {
            idleSound = (shouldPlayIdleSfx()) ? new PlayerFollowingLoopingSound(this.getIdleSound(), class_3419.field_15256, 0.25F) : null;
        }

        if (!shouldPlayIdleSfx() || hasChanged)
            this.field_22787.method_1483().method_4870(idleSound);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers))
            return true;

        if (this.canCloseWithKey() && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }

        return false;
    }

    public class_2338 getConsole() {
        return console;
    }

    public boolean shouldPlayIdleSfx() {
        return this.getIdleSound() != null;
    }

    public @Nullable class_3414 getIdleSound() {
        return AITSounds.MONITOR_IDLE;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        if (idleSound != null && !this.field_22787.method_1483().method_4877(idleSound))
            this.field_22787.method_1483().method_4873(idleSound);
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1483().method_4870(idleSound);

        super.method_25419();
    }

    public boolean canCloseWithKey() {
        return true;
    }
}
