package dev.amble.ait.client.screens;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_7077;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.data.ClientLandingManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.landing.LandingPadRegion;

public class LandingPadScreen extends class_437 {
    private static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/landing_marker_gui.png");
    private final class_2338 pos;
    private final LandingPadRegion landingRegion;
    int bgHeight = 137;
    int bgWidth = 191;
    int left, top;
    private class_342 landingCodeInput;

    public LandingPadScreen(class_2338 pos) {
        super(class_2561.method_43470("landing_pad"));

        this.field_22787 = class_310.method_1551();
        this.pos = pos;
        this.landingRegion = ClientLandingManager.getInstance().getRegion(new class_1923(pos));
    }

    @Override
    protected void method_25426() {
        this.top = (this.field_22790 - this.bgHeight) / 2; // this means everythings centered and scaling, same for below
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.landingCodeInput = new class_342(this.field_22793, (int) (left + (bgWidth * 0.06f)), (this.field_22790 / 2) - 20, 120, this.field_22793.field_2000 + 4,
                class_2561.method_43471("message.ait.landing_code"));
        this.addButton(new class_7077((field_22789 / 2 + 40), (field_22790 / 2) - 20,
                this.field_22793.method_1727("✓"), 20, class_2561.method_43470("✓").method_27692(class_124.field_1067), button -> {
            updateLandingCode();
        }, this.field_22793));

        this.landingCodeInput.method_1880(50);
        this.landingCodeInput.method_1858(true);
        this.landingCodeInput.method_1862(true);

        if (this.landingRegion == null) {
            this.method_25419();
            return;
        }

        if(this.landingRegion.getLandingCode().isBlank())
            this.landingCodeInput.method_47404(class_2561.method_43471("message.ait.enter_landing_code"));
        else
            this.landingCodeInput.method_1852(this.landingRegion.getLandingCode());

        this.method_25429(this.landingCodeInput);
        super.method_25426();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        // Check if a text field is focused to prevent closing
        if (this.landingCodeInput.method_20315())
            return super.method_25404(keyCode, scanCode, modifiers);

        // Close the screen when the inventory key is pressed
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void updateLandingCode() {
        class_2540 buf = PacketByteBufs.create();
        if (this.pos == null) return;

        buf.method_10807(this.pos);
        buf.method_10814(this.landingCodeInput.method_1882());

        ClientPlayNetworking.send(TardisUtil.REGION_LANDING_CODE, buf);
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063(button);
        button.field_22763 = true; // this whole method is unnecessary bc it defaults to true ( ?? )
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25302(TEXTURE, left, top, 0, 0, bgWidth, bgHeight);

        this.landingCodeInput.method_25394(context, mouseX, mouseY, delta);
        this.landingCodeInput.method_1868(this.landingCodeInput.method_25367() || !this.landingCodeInput.method_1882().isBlank() ? 0xffffff: 0x545454);

        super.method_25394(context, mouseX, mouseY, delta);
    }
}
