package dev.amble.ait.client.screens;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_7077;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_7842;
import com.google.common.collect.Lists;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedGlobalPos;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.exteriors.BedrockExteriorModel;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.client.screens.interior.InteriorSettingsScreen;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.category.ClassicCategory;
import dev.amble.ait.data.schema.exterior.category.ExclusiveCategory;
import dev.amble.ait.data.schema.exterior.category.PoliceBoxCategory;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;

public class MonitorScreen extends ConsoleScreen {
    private static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/monitor_gui.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    private ExteriorCategorySchema category;
    private ClientExteriorVariantSchema currentVariant;
    int backgroundHeight = 166;
    int backgroundWidth = 256;
    private int tickForSpin = 0;
    private final int APPLY_BUTTON_WIDTH = 53;
    private final int APPLY_BUTTON_HEIGHT = 20;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final int BIG_ARROW_BUTTON_WIDTH = 20;
    private final int BIG_ARROW_BUTTON_HEIGHT = 20;
    private final int INTERIOR_SETTINGS_BUTTON_WIDTH = 20;
    private final int INTERIOR_SETTINGS_BUTTON_HEIGHT = 20;

    public MonitorScreen(ClientTardis tardis, class_2338 console) {
        super(class_2561.method_43471("screen." + AITMod.MOD_ID + ".monitor"), tardis, console);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063(button);
        this.buttons.add((class_4185) button);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.createButtons();
    }

    public ExteriorCategorySchema getCategory() {
        return category == null ? this.tardis().getExterior().getCategory() : category;
    }

    public void setCategory(ExteriorCategorySchema category) {
        this.category = category;

        if (currentVariant == null)
            return;

        if (this.currentVariant.parent().category() != category)
            currentVariant = null;
    }

    public ClientExteriorVariantSchema getCurrentVariant() {
        if (currentVariant == null)
            if (!this.tardis().getExterior().getCategory().equals(getCategory())) {
                setCurrentVariant(this.getCategory().getDefaultVariant());
            } else {
                setCurrentVariant(this.tardis().getExterior().getVariant());
            }

        return currentVariant;
    }

    public void setCurrentVariant(ExteriorVariantSchema var) {
        setCurrentVariant(ClientExteriorVariantRegistry.withParent(var));
    }

    public void setCurrentVariant(ClientExteriorVariantSchema currentVariant) {
        this.currentVariant = currentVariant;
    }

    private void createButtons() {
        this.buttons.clear();
        // exterior change text button
        class_5250 applyText = class_2561.method_43471("screen.ait.monitor.apply");

        // apply text (exterior change screen)
        this.method_37060(new class_7842((field_22789 / 2 + 44), (field_22790 / 2 + 3),
                APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT, applyText.method_27692(class_124.field_1067), this.field_22793));

        // apply button (exterior change screen)
        this.addButton(new class_7077((field_22789 / 2 + 44), (field_22790 / 2 + 3),
                APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    sendExteriorPacket(this.tardis(), this.getCategory(), this.getCurrentVariant());
                }, this.field_22793));

        // arrow buttons (exterior change screen)
        this.addButton(new class_7077((field_22789 / 2 + 23), (field_22790 / 2 + 3),
                BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    changeCategory(false);
                }, this.field_22793));
        this.addButton(new class_7077((field_22789 / 2 + 98), (field_22790 / 2 + 3),
                BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    changeCategory(true);
                }, this.field_22793));

        // arrow buttons (exterior variant screen)
        this.addButton(new class_7077((field_22789 / 2 + 23), (field_22790 / 2 + 61),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    whichDirectionVariant(false);
                }, this.field_22793));
        this.addButton(new class_7077((field_22789 / 2 + 98), (field_22790 / 2 + 61),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    whichDirectionVariant(true);
                }, this.field_22793));

        // interior settings button
        this.addButton(new class_7077((field_22789 / 2 - 13), (field_22790 / 2 + 52),
                INTERIOR_SETTINGS_BUTTON_WIDTH, INTERIOR_SETTINGS_BUTTON_HEIGHT,
                class_2561.method_43473(),
                button -> toInteriorSettingsScreen(), this.field_22793));

        this.buttons.forEach(buttons -> {
            // buttons.visible = false;
            buttons.field_22763 = true;
        });
    }

    public static void sendExteriorPacket(ClientTardis tardis, ExteriorCategorySchema category,
            ClientExteriorVariantSchema variant) {
        if (category != tardis.getExterior().getCategory() || variant.parent() != tardis.getExterior().getVariant()) {
            ClientTardisUtil.changeExteriorWithScreen(tardis, variant.id(),
                    variant.parent() != tardis.getExterior().getVariant());
        }
    }

    public void toInteriorSettingsScreen() {
        if (tardis() == null || tardis().isGrowth())
            return;

        class_310.method_1551().method_29970(new InteriorSettingsScreen(this.tardis(), this.console, this));
    }

    public void changeCategory(boolean direction) {
        class_1657 player = class_310.method_1551().field_1724;

        if (player == null)
            return;

        if (direction)
            setCategory(nextCategory());
        else
            setCategory(previousCategory());

        if ((CategoryRegistry.EXCLUSIVE.equals(this.category) && !ExclusiveCategory.isUnlocked(player.method_5667()))
                || CategoryRegistry.CORAL_GROWTH.equals(this.category))
            changeCategory(direction);
    }

    public ExteriorCategorySchema nextCategory() {
        List<ExteriorCategorySchema> list = CategoryRegistry.getInstance().toList();

        int idx = list.indexOf(getCategory());
        idx = (idx + 1) % list.size();
        return list.get(idx);
    }

    public ExteriorCategorySchema previousCategory() {
        List<ExteriorCategorySchema> list = CategoryRegistry.getInstance().toList();

        int idx = list.indexOf(getCategory());
        idx = (idx - 1 + list.size()) % list.size();
        return list.get(idx);
    }

    public void whichDirectionVariant(boolean direction) {
        class_1657 player = class_310.method_1551().field_1724;

        if (player == null)
            return;

        if (direction)
            setCurrentVariant(nextVariant());
        else
            setCurrentVariant(previousVariant());
    }

    public ExteriorVariantSchema nextVariant() {
        List<ExteriorVariantSchema> list = ExteriorVariantRegistry.withParent(getCurrentVariant().parent().category())
                .stream().toList();

        int idx = list.indexOf(getCurrentVariant().parent());
        idx = (idx + 1) % list.size();
        return list.get(idx);
    }

    public ExteriorVariantSchema previousVariant() {
        List<ExteriorVariantSchema> list = ExteriorVariantRegistry.withParent(getCurrentVariant().parent().category())
                .stream().toList();

        int idx = list.indexOf(getCurrentVariant().parent());
        idx = (idx - 1 + list.size()) % list.size();
        return list.get(idx);
    }

    final int UV_BASE = 160;
    final int UV_INCREMENT = 19;

    int calculateUvOffsetForRange(int progress) {
        int rangeProgress = progress % 19;
        return (rangeProgress / 5) * UV_INCREMENT;
    }

    protected void drawBackground(class_332 context) {
        // just this whole thing is for the flight
        if (this.tardis() == null)
            return;

        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = ((this.field_22790) - this.backgroundHeight) / 2;
        context.method_25302(TEXTURE, i, j, 0, 0, this.backgroundWidth, this.backgroundHeight);

        // apply button (exterior change screen)
        if (!this.buttons.get(0).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(0).method_46426(), this.buttons.get(0).method_46427(), 40, 166,
                    APPLY_BUTTON_WIDTH,APPLY_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(0).method_46426(), this.buttons.get(0).method_46427(), 40, 186,
                    APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT);

        // arrow buttons (exterior change screen)
        if (!this.buttons.get(1).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(1).method_46426(), this.buttons.get(1).method_46427(), 0, 166,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(1).method_46426(), this.buttons.get(1).method_46427(), 0, 186,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);
        if (!this.buttons.get(2).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(2).method_46426(), this.buttons.get(2).method_46427(), 20, 166,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(2).method_46426(), this.buttons.get(2).method_46427(), 20, 186,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);

        // arrow buttons (exterior variant screen)
        if (!this.buttons.get(3).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(3).method_46426(), this.buttons.get(3).method_46427(), 93, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(3).method_46426(), this.buttons.get(3).method_46427(), 93, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        if (!this.buttons.get(4).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(4).method_46426(), this.buttons.get(4).method_46427(), 113, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(4).method_46426(), this.buttons.get(4).method_46427(), 113, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        // interior settings button
        if (!this.buttons.get(5).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(5).method_46426(), this.buttons.get(5).method_46427(), 186, 166,
                    INTERIOR_SETTINGS_BUTTON_WIDTH, INTERIOR_SETTINGS_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(5).method_46426(), this.buttons.get(5).method_46427(), 186, 186,
                    INTERIOR_SETTINGS_BUTTON_WIDTH, INTERIOR_SETTINGS_BUTTON_HEIGHT);

        context.method_25302(TEXTURE, i + 16, j + 144, 0,
                this.tardis().getFuel() > (FuelHandler.TARDIS_MAX_FUEL / 4) ? 225 : 234,
                (int) (85 * this.tardis().getFuel() / FuelHandler.TARDIS_MAX_FUEL), 9);

        int progress = this.tardis().travel().getDurationAsPercentage();

        for (int index = 0; index < 5; index++) {
            int rangeStart = index * 19;
            int rangeEnd = (index + 1) * 19;

            int uvOffset;
            if (progress >= rangeStart && progress <= rangeEnd) {
                uvOffset = calculateUvOffsetForRange(progress);
            } else if (progress >= rangeEnd) {
                uvOffset = 76;
            } else {
                uvOffset = UV_BASE;
            }

            context.method_25302(TEXTURE, i + 11 + (index * 19), j + 113,
                    this.tardis().travel().getState() == TravelHandlerBase.State.FLIGHT
                            ? progress >= 100 ? 76 : uvOffset
                            : UV_BASE,
                    206, 19, 19);
        }
    }

    protected void drawTardisExterior(class_332 context, int x, int y, float scale) {
        this.tickForSpin++;
        Tardis tardis = this.tardis();

        if (tardis == null)
            return;

        class_4587 stack = context.method_51448();

        int centerWidth = field_22789 / 2;
        int centerHeight = field_22790 / 2;

        ExteriorCategorySchema category = this.getCategory();
        ClientExteriorVariantSchema variant = this.getCurrentVariant();

        if (category == null || variant == null)
            return;

        boolean isPoliceBox = category.equals(CategoryRegistry.getInstance().get(PoliceBoxCategory.REFERENCE))
                || category.equals(CategoryRegistry.getInstance().get(ClassicCategory.REFERENCE));

        boolean isHorriblyUnscaled = variant.equals(ClientExteriorVariantRegistry.DOOM);

        boolean isExtUnlocked = tardis.isUnlocked(variant.parent());
        boolean hasPower = tardis.fuel().hasPower();
        boolean alarms = tardis.alarm().isEnabled();

        stack.method_22903();
        stack.method_46416(0, 0, 500f);

        context.method_27534(this.field_22793, category.text(), (centerWidth + 70), (centerHeight - 68),
                5636095);

        List<ExteriorVariantSchema> list = ExteriorVariantRegistry.withParent(category);

        context.method_27534(this.field_22793, class_2561.method_43470((list.indexOf(variant.parent()) + 1) + "/" + list.size()).method_27692(class_124.field_1067),
                (centerWidth + 70), (centerHeight + 64), 0xffffff);

        context.method_27534(this.field_22793, variant.parent().text(), (centerWidth + 70),
                (centerHeight + 44), 5636095);

        context.method_25300(this.field_22793, variant.parent().id().method_12836().toUpperCase(),
                (centerWidth + 70), (centerHeight + 34), 5636095);

        stack.method_22909();
        ExteriorModel model = variant.model();

        /*
         * stack.push(); stack.translate(0, 0, -50f);
         * stack.multiply(RotationAxis.NEGATIVE_Z.rotationDegrees(((float) tickForSpin /
         * 1400L) * 360.0f), x, y, 0); context.drawTexture(TEXTURE, x - 41, y - 41, 173,
         * 173, 83, 83); stack.pop();
         */

        stack.method_22903();
        stack.method_46416(x, isPoliceBox || isHorriblyUnscaled ? y + 11 : y, 100f);

        if (isPoliceBox) {
            stack.method_22905(-12, 12, 12);
        } else if (isHorriblyUnscaled) {
            stack.method_22905(-12, 12, 12);
        } else {
            stack.method_22905(-scale, scale, scale);
        }

        // datapack models float for some reason
        if (variant.model() instanceof BedrockExteriorModel) {
            stack.method_46416(0, 1.25f, 0);
        }

        stack.method_22907(class_7833.field_40715.rotationDegrees(((float) tickForSpin / 1200L) * 360.0f));

        class_2960 texture = variant.texture();
        class_2960 emissive = variant.emission();

        float base = isExtUnlocked ? 1f : 0.1f;
        float tinted = alarms && isExtUnlocked ? 0.3f : base;

        model.render(stack, context.method_51450().getBuffer(AITRenderLayers.method_23689(texture)),
                class_765.field_32767, class_4608.field_21444, base, base, base, 1f);

        if (hasPower && emissive != null && !(emissive.equals(DatapackConsole.EMPTY))) {
            model.render(stack, context.method_51450().getBuffer(AITRenderLayers.tardisEmissiveCullZOffset(emissive, true)),
                    class_765.field_32767, class_4608.field_21444, base, base, base, 1f);
        }

        stack.method_22909();

        stack.method_22903();
        stack.method_46416(0, 0, 550f);

        context.method_25300(this.field_22793, isExtUnlocked ? "" : "\uD83D\uDD12", x, y,
                0xFFFFFF);

        //float h = (float) (-textRenderer.getWidth("\uD83D\uDD12") / 2);

        //Matrix4f matrix4f = stack.peek().getPositionMatrix();
        class_4597 vertex = context.method_51450();

        //textRenderer.draw(Text.literal("\uD83D\uDD12"), h + 0.35f, 0.0F, 0xFFFFFFFF, false, matrix4f, vertex,
                //TextRenderer.TextLayerType.SEE_THROUGH, 0x000000, 0xf000f0);

        stack.method_22903();
        stack.method_46416(0, 0, 50f);

        context.method_25300(this.field_22793, isExtUnlocked ? "" : "\uD83D\uDD12", x, y, 0xFFFFFF);

        stack.method_22909();

        stack.method_22909();
    }

    @Override
    public void method_25420(class_332 context) {
        super.method_25420(context);
    }

    protected void drawInformationText(class_332 context) {
        if (this.tardis() == null)
            return;

        TravelHandler travel = this.tardis().travel();
        DirectedGlobalPos abpd = travel.getState() == TravelHandlerBase.State.FLIGHT
                ? travel.getProgress()
                : travel.position();
        CachedDirectedGlobalPos dabpd = travel.destination();

        if (abpd.getDimension() == null)
            return;

        class_2338 abpdPos = abpd.getPos();

        String positionText = abpdPos.method_10263() + ", " + abpdPos.method_10264() + ", " + abpdPos.method_10260();
        class_2561 dimensionText = WorldUtil.worldText(abpd.getDimension());

        class_2338 dabpdPos = dabpd.getPos();

        String destinationText = dabpdPos.method_10263() + ", " + dabpdPos.method_10264() + ", " + dabpdPos.method_10260();
        class_2561 dDimensionText = WorldUtil.worldText(dabpd.getDimension(), false);

        // position
        context.method_51439(this.field_22793, class_2561.method_43470(positionText), (field_22789 / 2 - 119), (field_22790 / 2 - 48), 0xFFFFFF,
                true);
        context.method_51439(this.field_22793, dimensionText, (field_22789 / 2 - 119), (field_22790 / 2 - 38), 0xFFFFFF, true);
        context.method_51430(this.field_22793, WorldUtil.rot2Text(abpd.getRotation()).method_30937(), (field_22789 / 2 - 119), (field_22790 / 2 - 28), 0xFFFFFF,
                true);

        // destination
        context.method_51439(this.field_22793, class_2561.method_43470(destinationText), (field_22789 / 2 - 119), (field_22790 / 2 - 10),
                0xFFFFFF, true);
        context.method_51439(this.field_22793, dDimensionText, (field_22789 / 2 - 119), (field_22790 / 2), 0xFFFFFF, true);
        context.method_51430(this.field_22793, WorldUtil.rot2Text(dabpd.getRotation()).method_30937(), (field_22789 / 2 - 119), (field_22790 / 2 + 10),
                0xFFFFFF, true);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i = ((this.field_22790 - this.backgroundHeight) / 2); // loqor make sure to use these so it stays consistent on
                                                                // different sized
        // screens
        // (kind of ??)
        int j = ((this.field_22789 - this.backgroundWidth) / 2);
        // background behind the tardis and gallifreyan text
        class_4587 stack = context.method_51448();
        this.drawTardisExterior(context, (field_22789 / 2 + 70), (field_22790 / 2 - 30), 19f);
        this.drawBackground(context);
        // todo manually adjusting all these values are annoying me
        this.drawInformationText(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }
}
