package dev.amble.ait.client.screens;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7077;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.ait.registry.impl.SonicRegistry;

public class SonicSettingsScreen extends ConsoleScreen {
    private static final class_2960 BACKGROUND = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/sonic_selection.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    int bgHeight = 130;
    int bgWidth = 216;
    int left, top;
    int choicesCount = 0;
    private final class_437 parent;
    private int selectedSonic;
    private final int APPLY_BAR_BUTTON_WIDTH = 53;
    private final int APPLY_BAR_BUTTON_HEIGHT = 12;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final class_2338 console;

    public SonicSettingsScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super(class_2561.method_43471("screen." + AITMod.MOD_ID + ".sonicsettings.title"), tardis, console);
        this.console = console;
        this.parent = parent;
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        if (!(class_310.method_1551().field_1687.method_8321(this.console) instanceof ConsoleBlockEntity consoleBlockEntity)) return;
        SonicSchema schema = SonicItem.schema(consoleBlockEntity.getSonicScrewdriver()/*tardis().sonic().getConsoleSonic()*/);

        this.selectedSonic = SonicRegistry.getInstance().toList().indexOf(schema);
        this.top = (this.field_22790 - this.bgHeight) / 2; // this means everythings centered and scaling, same for below
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();

        super.method_25426();
    }

    private void createButtons() {
        choicesCount = 0;
        this.buttons.clear();

        // apply bar button
        this.addButton(new AITPressableTextWidget((int) (left + (bgWidth * 0.139f)), (int) (top + (bgHeight * 0.839f)),
                APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT, class_2561.method_43473(), button -> {
                    sendSonicChangePacket();
                }, this.field_22793));

        // back button
        class_2561 back = class_2561.method_43471("screen.ait.sonicsettings.back");
        this.addButton(new class_7077((field_22789 / 2 - 102), (field_22790 / 2 - 59), this.field_22793.method_27525(back),
                10, back, button -> backToInteriorSettings(), this.field_22793));

        // arrow buttons
        this.addButton(new AITPressableTextWidget((int) (left + (bgWidth * 0.042f)), (int) (top + (bgHeight * 0.839f)),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.getLastSelectedSonic(),
                this.field_22793));
        this.addButton(new AITPressableTextWidget((int) (left + (bgWidth * 0.389f)), (int) (top + (bgHeight * 0.839f)),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.getNextSelectedSonic(),
                this.field_22793));
    }

    public void backToInteriorSettings() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void sendSonicChangePacket() {
        if (!(class_310.method_1551().field_1687.method_8321(this.console) instanceof ConsoleBlockEntity consoleBlockEntity)) return;
        if (consoleBlockEntity.getSonicScrewdriver()/*this.tardis().sonic().getConsoleSonic()*/ == null)
            return;

        SonicSchema schema = SonicRegistry.getInstance().toList().get(this.selectedSonic);

        if (!this.tardis().isUnlocked(schema))
            return;

        SonicItem.setSchema(consoleBlockEntity.getSonicScrewdriver()/*tardis().sonic().getConsoleSonic()*/, schema);
        ClientTardisUtil.changeSonicWithScreen(this.tardis().getUuid(), schema, this.console);
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063(button);
        button.field_22763 = true; // this whole method is unnecessary bc it defaults to true ( ?? ) - does it
        // though?
        this.buttons.add((class_4185) button);
    }

    private void createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        this.addButton(new class_7077((int) (left + (bgWidth * 0.06f)),
                (int) (top + (bgHeight * (0.1f * (choicesCount + 1)))), this.field_22793.method_27525(text), 10, text,
                onPress, this.field_22793));

        choicesCount++;
    }

    @Override
    public void method_25420(class_332 context) {
        super.method_25420(context);
    }

    protected void drawSonicScrewdriver(class_332 context, int x, int y, float scale) {
        if (this.tardis() == null)
            return;

        if (!(class_310.method_1551().field_1687.method_8321(this.console) instanceof ConsoleBlockEntity consoleBlockEntity)) return;

        if (consoleBlockEntity.getSonicScrewdriver()/*this.tardis().sonic().getConsoleSonic()*/ == null)
            return;

        class_1799 sonic = consoleBlockEntity.getSonicScrewdriver(); //this.tardis().sonic().getConsoleSonic();
        if (sonic.method_7960()) return;
        class_2487 nbt = sonic.method_7948();

        if (this.tardis() != null) {
            class_4587 stack = context.method_51448();

            class_1799 sonicCopy = sonic.method_7972();
            SonicSchema schema = SonicRegistry.getInstance().toList().get(this.selectedSonic);

            SonicItem.setSchema(sonicCopy, schema);

            stack.method_22903();
            stack.method_46416(50f, 50f, 1000f);
            context.method_25300(this.field_22793, (tardis().isUnlocked(schema)) ? "" : "\uD83D\uDD12",
                    x, y, 0xFFFFFF);
            stack.method_22909();

            stack.method_22903();

            SonicSchema.Rendering rendering = schema.rendering();
            SonicSchema.Rendering.Offset positionOffset = rendering.getPositionOffset();
            SonicSchema.Rendering.Offset scaleOffset = rendering.getScaleOffset();

            stack.method_46416(x + positionOffset.x(), y + positionOffset.y(), positionOffset.z());
            stack.method_22905(scale + scaleOffset.x(), scale + scaleOffset.y(), scale + scaleOffset.z());

            boolean isSonicUnlocked = tardis().isUnlocked(schema);

            float base = isSonicUnlocked ? 1f : 0.1f;

            RenderSystem.setShaderColor(base, base, base, 1f);
            class_308.method_24210();
            context.method_51427(sonicCopy, 0, 0);
            class_308.method_24211();
            RenderSystem.setShaderColor(1, 1, 1, 1);

            stack.method_22909();

            stack.method_22903();
            stack.method_46416(10, 0, 500f);
            context.method_27534(this.field_22793, class_2561.method_43471("screen.ait.sonic_casing"), x + 140, y + 10,
                    0xFFFFFF);
            context.method_25300(this.field_22793, SonicItem.schema(sonicCopy).name(), x + 140,
                    y + 20, 0x00FFFF);
            context.method_27534(this.field_22793, class_2561.method_43471("screen.ait.current_au"), x + 140, y + 40, 0xFFFFFF);
            context.method_25300(this.field_22793, nbt.method_10574(SonicItem.FUEL_KEY) + " AU", x + 140,
                    y + 50, 0x00FFFF);

            UUID tardis = LinkableItem.getTardisIdStatic(sonicCopy);

            if (tardis != null) {
                context.method_27534(this.field_22793, class_2561.method_43471("screen.ait.linked_tardis"), x + 140, y + 70,
                        0xFFFFFF);
                context.method_25300(this.field_22793, tardis.toString().substring(0, 8), x + 140,
                        y + 80, 0x00FFFF);
            }

            stack.method_22909();
        }
    }

    public void getNextSelectedSonic() {
        this.selectedSonic = (this.selectedSonic + 1) % SonicRegistry.getInstance().size();
    }

    public void getLastSelectedSonic() {
        this.selectedSonic = (this.selectedSonic - 1 + SonicRegistry.getInstance().size()) % SonicRegistry.getInstance().size();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);
        this.drawSonicScrewdriver(context, (field_22789 / 2 - 100), (field_22790 / 2 - 45), 6f);

        // apply bar button
        if (!this.buttons.get(0).method_49606())
            context.method_25302(BACKGROUND, left + 30, top + 109, 40, 130, APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT);
        else
            context.method_25302(BACKGROUND, left + 30, top + 109, 40, 142, APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT);

        // arrow buttons
        if (!this.buttons.get(2).method_49606())
            context.method_25302(BACKGROUND, left + 9, top + 109, 0, 130, SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(BACKGROUND, left + 9, top + 109, 0, 142, SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        if (!this.buttons.get(3).method_49606())
            context.method_25302(BACKGROUND, left + 84, top + 109, 20, 130, SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(BACKGROUND, left + 84, top + 109, 20, 142, SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(BACKGROUND, left, top, 0, 0, bgWidth, bgHeight);
        context.method_25302(BACKGROUND, left + 9, top + 25, 0, 154, 95, 84);
    }

    public static class AITPressableTextWidget extends class_4185 {
        private final class_327 textRenderer;
        private final class_2561 text;
        // private final Text hoverText;
        public AITPressableTextWidget(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress,
                class_327 textRenderer) {
            super(x, y, width, height, text, onPress, field_40754);
            this.textRenderer = textRenderer;
            this.text = text;
            // this.hoverText = Texts.setStyleIfAbsent(text.copy(),
            // Style.EMPTY.withUnderline(true));
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2561 text = /* this.isSelected() ? this.hoverText : */ this.text;
            context.method_27535(this.textRenderer, text, this.method_46426(), this.method_46427(),
                    16777215 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        }
    }
}
