package dev.amble.ait.client.screens;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.core.tardis.handler.permissions.PermissionHandler;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.properties.Value;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7077;

public class TardisSecurityScreen extends ConsoleScreen {
    private static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/security_menu.png");
    int bgHeight = 138;
    int bgWidth = 216;
    int left, top;
    int choicesCount = 0;
    private final class_437 parent;
    private class_342 landingCodeInput;

    public TardisSecurityScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super(class_2561.method_43471("screen.ait.security.title"), tardis, console);
        this.parent = parent;
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        this.top = (this.field_22790 - this.bgHeight) / 2; // this means everythings centered and scaling, same for below
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();

        super.method_25426();
    }

    @Override
    public boolean canCloseWithKey() {
        return !this.landingCodeInput.method_20315();
    }

    private void createButtons() {
        choicesCount = 0;

        createTextButton(class_2561.method_43471("screen.ait.interiorsettings.back"),
                (button -> backToExteriorChangeScreen()));
        createTextButton(class_2561.method_43471("screen.ait.security.leave_behind"), (button -> toggleLeaveBehind()));
        createTextButton(class_2561.method_43471("screen.ait.security.hostile_alarms"), (button -> toggleHostileAlarms()));
        createTextButton(class_2561.method_43471("screen.ait.security.minimum_loyalty"), (button -> changeMinimumLoyalty()));
        createTextButton(class_2561.method_43471("screen.ait.security.receive_distress_calls"), (button -> receiveDistressCalls()));

        this.landingCodeInput = new class_342(this.field_22793, (int) (left + (bgWidth * 0.06f)), this.top + 85, 120, this.field_22793.field_2000 + 4,
                class_2561.method_43471("message.ait.landing_code"));
        this.addButton(new class_7077((field_22789 / 2 + 40), (field_22790 / 2 + 18),
                this.field_22793.method_1727("✓"), 20, class_2561.method_43470("✓").method_27692(class_124.field_1067), button -> {
            updateLandingCode();
        }, this.field_22793));

        this.landingCodeInput.method_1880(50);
        this.landingCodeInput.method_1858(true);
        this.landingCodeInput.method_1862(true);

        if(this.tardis().landingPad().code().get().isBlank())
            this.landingCodeInput.method_47404(class_2561.method_43471("message.ait.enter_landing_code"));
        else
            this.landingCodeInput.method_1852(this.tardis().landingPad().code().get());

        this.method_25429(this.landingCodeInput);
    }

    private void receiveDistressCalls() {
        Value<Boolean> receiveCalls = this.tardis().<StatsHandler>handler(TardisComponent.Id.STATS).receiveCalls();
        receiveCalls.set(!receiveCalls.get());
    }

    private void toggleLeaveBehind() {
        this.tardis().travel().leaveBehind().flatMap(value -> !value);
    }

    private void changeMinimumLoyalty() {
        ClientTardis tardis = this.tardis();
        PermissionHandler.p19Loyalty(tardis, getMinimumLoyalty(tardis).next());
    }

    private static Loyalty.Type getMinimumLoyalty(ClientTardis tardis) {
        return tardis.<PermissionHandler>handler(TardisComponent.Id.PERMISSIONS).p19Loyalty().get();
    }

    private void toggleHostileAlarms() {
        this.tardis().alarm().hostilePresence().flatMap(value -> !value);
    }

    private void updateLandingCode() {
        String input = this.landingCodeInput.method_1882();

        this.tardis().landingPad().code().set(input);
    }

    private <T extends class_339> void addButton(T button) {
        this.method_37063(button);
        button.field_22763 = true; // this whole method is unnecessary bc it defaults to true ( ?? )
    }

    // this might be useful, so remember this exists and use it later on
    private void createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        this.addButton(new class_7077((int) (left + (bgWidth * 0.06f)),
                (int) (top + (bgHeight * (0.1f * (choicesCount + 1)))), this.field_22793.method_27525(text), 10, text,
                onPress, this.field_22793));

        choicesCount++;
    }

    public void backToExteriorChangeScreen() {
        class_310.method_1551().method_1507(this.parent);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackground(context);

        ClientTardis tardis = this.tardis();

        class_2561 onText = class_2561.method_43471("screen.ait.monitor.on");
        class_2561 offText = class_2561.method_43471("screen.ait.monitor.off");


        context.method_51439(this.field_22793,
                class_2561.method_43473().method_27693(": ").method_10852(tardis.travel().leaveBehind().get() ? onText : offText),
                (int) (left + (bgWidth * 0.46f)), (int) (top + (bgHeight * (0.1f * 2))), 0xffA500, false);


        context.method_51439(this.field_22793,
                class_2561.method_43473().method_27693(": ").method_10852(tardis.alarm().hostilePresence().get() ? onText : offText),
                (int) (left + (bgWidth * 0.48f)), (int) (top + (bgHeight * (0.1f * 3))), 0xffA500, false);


        context.method_51439(this.field_22793,
                class_2561.method_43470(": ").method_10852(getMinimumLoyalty(tardis).text()),
                (int) (left + (bgWidth * 0.51f)), (int) (top + (bgHeight * (0.1f * 4))), 0xffA500, false);


        context.method_51439(this.field_22793,
                class_2561.method_43471("message.ait.date_created"),
                (int) (left + (bgWidth * 0.06f)),
                (int) (top + (bgHeight * (0.1f * 7.5))), 0xadcaf7, false);


        context.method_51439(this.field_22793,
                class_2561.method_43470(tardis.stats().getCreationString()),
                (int) (left + (bgWidth * 0.06f)),
                (int) (top + (bgHeight * (0.1f * 8.5))), 0xadcaf7, false);


        context.method_51439(this.field_22793,
                class_2561.method_43473().method_27693(": ").method_10852(this.tardis().<StatsHandler>handler(TardisComponent.Id.STATS).receiveCalls().get() ? onText : offText),
                (int) (left + (bgWidth * 0.7f)), (int) (top + (bgHeight * (0.1f * 5))), 0xffA500, false);

        this.landingCodeInput.method_25394(context, mouseX, mouseY, delta);
        this.landingCodeInput.method_1868(this.landingCodeInput.method_25367() || !this.landingCodeInput.method_1882().isBlank() ? 0xffffff: 0x545454);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(TEXTURE, left, top, 0, 0, bgWidth, bgHeight);
    }
}
