package dev.amble.ait.client.screens.interior;

import static dev.amble.ait.core.tardis.handler.InteriorChangingHandler.CHANGE_DESKTOP;

import java.util.List;
import java.util.function.Function;

import com.google.common.collect.Lists;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7077;
import net.minecraft.class_7842;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.api.tardis.TardisClientEvents;
import dev.amble.ait.client.screens.ConsoleScreen;
import dev.amble.ait.client.screens.SonicSettingsScreen;
import dev.amble.ait.client.screens.TardisSecurityScreen;
import dev.amble.ait.client.screens.widget.SwitcherManager;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.compat.DependencyChecker;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;

@Environment(EnvType.CLIENT)
public class InteriorSettingsScreen extends ConsoleScreen {
    private static final class_2960 BACKGROUND = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/interior_settings.png");
    private static final class_2960 TEXTURE = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/interior_settings.png");
    private static final class_2960 MISSING_PREVIEW = new class_2960(AITMod.MOD_ID,
            "textures/gui/tardis/monitor/presets/missing_preview.png");
    private final List<class_4185> buttons = Lists.newArrayList();
    int bgHeight = 166;
    int bgWidth = 256;
    int left, top;
    private int tickForSpin = 0;
    public int choicesCount = 0;
    private final class_437 parent;
    private TardisDesktopSchema selectedDesktop;
    private SwitcherManager.ModeManager modeManager;
    private final int APPLY_BUTTON_WIDTH = 53;
    private final int APPLY_BUTTON_HEIGHT = 20;
    private final int APPLY_BAR_BUTTON_WIDTH = 53;
    private final int APPLY_BAR_BUTTON_HEIGHT = 12;
    private final int SMALL_ARROW_BUTTON_WIDTH = 20;
    private final int SMALL_ARROW_BUTTON_HEIGHT = 12;
    private final int BIG_ARROW_BUTTON_WIDTH = 20;
    private final int BIG_ARROW_BUTTON_HEIGHT = 20;
    private final int MAIN_SETTINGS_BUTTON_WIDTH = 20;
    private final int MAIN_SETTINGS_BUTTON_HEIGHT = 20;
    private class_2338 console;

    public InteriorSettingsScreen(ClientTardis tardis, class_2338 console, class_437 parent) {
        super(class_2561.method_43471("screen." + AITMod.MOD_ID + ".interiorsettings.title"), tardis, console);
        this.parent = parent;
        this.console = console;
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        this.modeManager = new SwitcherManager.ModeManager(this.tardis());
        this.selectedDesktop = tardis().getDesktop().getSchema();

        if (this.selectedDesktop == null)
            this.nextDesktop();

        this.top = (this.field_22790 - this.bgHeight) / 2; // this means everythings centered and scaling, same for below
        this.left = (this.field_22789 - this.bgWidth) / 2;
        this.createButtons();

        super.method_25426();
    }

    private void sendCachePacket() {
        if (this.console == null)
            return;

        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.tardis().getUuid());
        buf.method_10807(this.console);

        ClientPlayNetworking.send(TardisDesktop.CACHE_CONSOLE, buf);
        this.method_25419();
    }

    private void createCompatButtons() { }

    private void createButtons() {
        choicesCount = 0;
        this.buttons.clear();

        createTextButton(class_2561.method_43471("screen.ait.interiorsettings.cacheconsole")
                .method_27692(this.console != null ? class_124.field_1068 : class_124.field_1080), button -> sendCachePacket());
        createTextButton(class_2561.method_43471("screen.ait.security.button"), (button -> toSecurityScreen()));

        boolean showSonicButton = console != null && class_310.method_1551().field_1687.method_8321(console) instanceof ConsoleBlockEntity consoleBlock
                && consoleBlock.getSonicScrewdriver() != null && !consoleBlock.getSonicScrewdriver().method_7960();

        createTextButton(class_2561.method_43471("screen.ait.sonic.button")
                .method_27692(showSonicButton ? class_124.field_1068 : class_124.field_1080), button -> {
                    if (showSonicButton)
                        toSonicScreen();
                });

        this.createCompatButtons();
        TardisClientEvents.SETTINGS_SETUP.invoker().onSetup(this);

        // arrow - hum/misc screen - left
        this.addButton(new class_7077((field_22789 / 2 + 23), (field_22790 / 2 + 61),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.modeManager.get().previous(), this.field_22793));

        // arrow - hum/misc screen - right
        this.addButton(new class_7077((field_22789 / 2 + 98), (field_22790 / 2 + 61),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.modeManager.get().next(), this.field_22793));

        // apply (HUM)
        this.addButton(new class_7077((field_22789 / 2 + 44), (field_22790 / 2 + 61),
                APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.modeManager.get().sync(this.tardis()), this.field_22793));

        // arrows (Interior)
        this.addButton(new class_7077((field_22789 / 2 + 23), (field_22790 / 2 + 3), BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT,
                class_2561.method_43473(), button -> {
                    previousDesktop();
                }, this.field_22793));
        this.addButton(new class_7077((field_22789 / 2 + 98), (field_22790 / 2 + 3), BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT,
                class_2561.method_43473(), button -> {
                    nextDesktop();
                }, this.field_22793));

        // apply (Interior)
        class_5250 applyInteriorText = class_2561.method_43471("screen.ait.monitor.apply");
        this.method_37060(new class_7842((field_22789 / 2 + 44), (field_22790 / 2 + 3),
                APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT, applyInteriorText.method_27692(class_124.field_1067), this.field_22793));
        this.addButton(new class_7077((field_22789 / 2 + 44), (field_22790 / 2 + 3),
                APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT, class_2561.method_43473(), button -> applyDesktop(), this.field_22793));

        // back to main monitor menu
        this.addButton(new class_7077((field_22789 / 2 - 13), (field_22790 / 2 + 52),
                MAIN_SETTINGS_BUTTON_WIDTH, MAIN_SETTINGS_BUTTON_HEIGHT,
                class_2561.method_43473(),
                button -> backToExteriorChangeScreen(), this.field_22793));


        // arrows (HUM) mode selector
        this.addButton(new class_7077((field_22789 / 2 + 77), (field_22790 / 2 + 30),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.modeManager.previous(), this.field_22793));
        this.addButton(new class_7077((field_22789 / 2 + 98), (field_22790 / 2 + 30),
                SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT, class_2561.method_43473(), button -> this.modeManager.next(), this.field_22793));
    }

    private void toSonicScreen() {
        class_310.method_1551().method_1507(new SonicSettingsScreen(this.tardis(), this.console, this));
    }

    public <T extends class_339> void addButton(T button) {
        this.method_37063(button);
        button.field_22763 = true; // this whole method is unnecessary bc it defaults to true ( ?? )
        this.buttons.add((class_4185) button);
    }

    public class_7077 createTextButton(class_2561 text, class_4185.class_4241 onPress) {
        return this.createAnyButton(text, class_7077::new, onPress);
    }

    public <T extends class_4185> T initAnyButton(class_2561 text, ButtonCreator<T> creator,
            class_4185.class_4241 onPress) {
        return creator.create((int) (left + (bgWidth * 0.06f)), (int) (top + (bgHeight * (0.1f * (choicesCount + 1)))),
                this.field_22793.method_27525(text), 10, text, onPress, this.field_22793);
    }

    public <T extends class_4185> T initAnyDynamicButton(Function<T, class_2561> text, DynamicButtonCreator<T> creator,
            class_4185.class_4241 onPress) {
        return creator.create((int) (left + (bgWidth * 0.06f)), (int) (top + (bgHeight * (0.1f * (choicesCount + 1)))),
                this.field_22793.method_27525(class_2561.method_43473()), 10, text, onPress, this.field_22793);
    }

    public <T extends class_4185> T createAnyButton(class_2561 text, ButtonCreator<T> creator,
            class_4185.class_4241 onPress) {
        T result = this.initAnyButton(text, creator, onPress);

        this.addButton(result);
        choicesCount++;

        return result;
    }

    public <T extends class_4185> T createAnyDynamicButton(Function<T, class_2561> text, DynamicButtonCreator<T> creator,
            class_4185.class_4241 onPress) {
        T result = this.initAnyDynamicButton(text, creator, onPress);

        this.addButton(result);
        choicesCount++;

        return result;
    }

    public void backToExteriorChangeScreen() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void toSecurityScreen() {
        class_310.method_1551().method_1507(new TardisSecurityScreen(tardis(), this.console, this));
    }

    final int UV_BASE = 160;
    final int UV_INCREMENT = 19;

    int calculateUvOffsetForRange(int progress) {
        int rangeProgress = progress % 19;
        return (rangeProgress / 5) * UV_INCREMENT;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i = (this.field_22789 - this.bgWidth) / 2;
        int j = ((this.field_22790) - this.bgHeight) / 2;
        this.renderDesktop(context);
        this.drawBackground(context); // the grey backdrop
        context.method_51448().method_22903();
        int x = (left + 79);
        int y = (top + 59);
        context.method_51448().method_46416(0, 0, 0f);
        context.method_51448().method_22909();

        // TODO: this is a fucking nightmare
        int buttonIndex = DependencyChecker.hasGravity() ? 4 : 3;

        // arrow buttons (hum/misc screen)
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        // apply bar button (hum/misc screen)
        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 133, 166,
                    APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 133, 178,
                    APPLY_BAR_BUTTON_WIDTH, APPLY_BAR_BUTTON_HEIGHT);

        // arrow buttons (interior)
        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 0, 166,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 0, 186,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);

        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 20, 166,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 20, 186,
                    BIG_ARROW_BUTTON_WIDTH, BIG_ARROW_BUTTON_HEIGHT);

        // apply button (interior)
        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 40, 166,
                    APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 40, 186,
                    APPLY_BUTTON_WIDTH, APPLY_BUTTON_HEIGHT);

        // back to main monitor menu button
        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 186, 166,
                    MAIN_SETTINGS_BUTTON_WIDTH, MAIN_SETTINGS_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 186, 186,
                    MAIN_SETTINGS_BUTTON_WIDTH, MAIN_SETTINGS_BUTTON_HEIGHT);

        // arrow buttons (hum/misc screen) - mode selector
        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 93, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);

        buttonIndex++;
        if (!this.buttons.get(buttonIndex).method_49606())
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 166,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);
        else
            context.method_25302(TEXTURE, this.buttons.get(buttonIndex).method_46426(), this.buttons.get(buttonIndex).method_46427(), 113, 178,
                    SMALL_ARROW_BUTTON_WIDTH, SMALL_ARROW_BUTTON_HEIGHT);


        if (tardis() == null)
            return;

        // Fuel
        context.method_25302(TEXTURE, i + 16, j + 144, 0,
                this.tardis().getFuel() > (FuelHandler.TARDIS_MAX_FUEL / 4) ? 225 : 234,
                (int) (85 * this.tardis().getFuel() / FuelHandler.TARDIS_MAX_FUEL), 9);


        // fuel markers @TODO come back and actually do the rest of it with the halves
        // and the red
        // parts
        // too

        // Flight Progress
        int progress = this.tardis().travel().getDurationAsPercentage();

        for (int index = 0; index < 5; index++) {
            int rangeStart = index * 19;
            int rangeEnd = (index + 1) * 19;

            int uvOffset;
            if (progress >= rangeStart && progress <= rangeEnd) {
                uvOffset = calculateUvOffsetForRange(progress);
            } else if (progress >= rangeEnd) {
                uvOffset = 76;
            } else {
                uvOffset = UV_BASE;
            }

            context.method_25302(TEXTURE, i + 11 + (index * 19), j + 113,
                    this.tardis().travel().getState() == TravelHandlerBase.State.FLIGHT
                            ? progress >= 100 ? 76 : uvOffset
                            : UV_BASE,
                    206, 19, 19);
        }


        this.renderCurrentMode(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context) {
        context.method_25302(BACKGROUND, left, top, 0, 0, bgWidth, bgHeight);
    }

    private void renderDesktop(class_332 context) {
        if (this.selectedDesktop == null)
            return;

        context.method_51448().method_22903();
        context.method_51448().method_46416(0, 0, 15f);
        context.method_25300(this.field_22793, this.selectedDesktop.name(),
                (int) (left + (bgWidth * 0.77f)), (int) (top + (bgHeight * 0.080f)), 0xffffff);
        context.method_51448().method_22909();

        context.method_51448().method_22903();
        context.method_25293(
                doesTextureExist(this.selectedDesktop.previewTexture().texture())
                        ? this.selectedDesktop.previewTexture().texture()
                        : MISSING_PREVIEW,
                left + 151, top + 10, 95, 95, 0, 0, this.selectedDesktop.previewTexture().width * 2,
                this.selectedDesktop.previewTexture().height * 2, this.selectedDesktop.previewTexture().width * 2,
                this.selectedDesktop.previewTexture().height * 2);

        context.method_51448().method_22909();
    }

    private void renderCurrentMode(class_332 context) {
        Nameable current = this.modeManager.get().get();

        class_2561 modeText = class_2561.method_43470(this.modeManager.get().name().toUpperCase());
        context.method_51439(this.field_22793, modeText,
                (field_22789 / 2 + 50) - this.field_22793.method_27525(modeText) / 2,
                field_22790 / 2 + 32, 0xffffff, true);
        class_2561 currentText = class_2561.method_43470(current .name().toUpperCase());
        context.method_51439(this.field_22793, currentText, (int) (left + (bgWidth * 0.78f)) - this.field_22793.method_27525(currentText) / 2,
                (int) (top + (bgHeight * 0.792f)), 0xffffff, true);
    }

    private void applyDesktop() {
        if (this.selectedDesktop == null)
            return;

        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(tardis().getUuid());
        buf.method_10812(this.selectedDesktop.id());

        ClientPlayNetworking.send(CHANGE_DESKTOP, buf);

        class_310.method_1551().method_1507(null);
    }

    private static TardisDesktopSchema nextDesktop(TardisDesktopSchema current) {
        List<TardisDesktopSchema> list = DesktopRegistry.getInstance().toList();

        int idx = current == null ? -1 : list.indexOf(current);
        idx = (idx + 1) % list.size();
        return list.get(idx);
    }

    private void nextDesktop() {
        this.selectedDesktop = nextDesktop(this.selectedDesktop);

        if (!isCurrentUnlocked() || this.selectedDesktop == DesktopRegistry.DEFAULT_CAVE)
            nextDesktop(); // ooo incursion crash
    }

    private static TardisDesktopSchema previousDesktop(TardisDesktopSchema current) {
        List<TardisDesktopSchema> list = DesktopRegistry.getInstance().toList();

        int idx = current == null ? -1 : list.indexOf(current);
        idx = (idx - 1 + list.size()) % list.size();
        return list.get(idx);
    }

    private void previousDesktop() {
        this.selectedDesktop = previousDesktop(this.selectedDesktop);

        if (!isCurrentUnlocked() || this.selectedDesktop == DesktopRegistry.DEFAULT_CAVE)
            previousDesktop(); // ooo incursion crash
    }

    public static boolean doesTextureExist(class_2960 id) {
        return class_310.method_1551().method_1478().method_14486(id).isPresent();
    }

    private boolean isCurrentUnlocked() {
        return this.tardis().isUnlocked(this.selectedDesktop);
    }

    @FunctionalInterface
    public interface ButtonCreator<T extends class_4185> {
        T create(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress,
                class_327 textRenderer);
    }

    @FunctionalInterface
    public interface DynamicButtonCreator<T extends class_4185> {
        T create(int x, int y, int width, int height, Function<T, class_2561> text, class_4185.class_4241 onPress,
                class_327 textRenderer);
    }
}
