package dev.amble.ait.client.screens.widget;

import java.util.function.Function;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;

@Environment(EnvType.CLIENT)
public class DynamicPressableTextWidget extends class_4185 {
    private final class_327 textRenderer;
    private final Function<DynamicPressableTextWidget, class_2561> text;

    private boolean leftClick = true;

    private class_2561 cached;
    private class_2561 hoverText;

    public DynamicPressableTextWidget(int x, int y, int width, int height,
            Function<DynamicPressableTextWidget, class_2561> text, class_4185.class_4241 onPress,
            class_327 textRenderer) {
        super(x, y, width, height, class_2561.method_43473(), onPress, field_40754);

        this.textRenderer = textRenderer;
        this.text = text;

        this.refresh();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22763 || !this.field_22764)
            return false;

        if (!this.method_25361(mouseX, mouseY))
            return false;

        this.leftClick = button == 0;

        this.method_25354(class_310.method_1551().method_1483());
        this.method_25348(mouseX, mouseY);
        return true;
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_2561 text = this.method_25367() ? this.hoverText : this.cached;
        context.method_27535(this.textRenderer, text, this.method_46426(), this.method_46427(),
                0xFFFFFF | class_3532.method_15386(this.field_22765 * 255.0f) << 24);
    }

    public boolean isLeftClick() {
        return leftClick;
    }

    public void refresh() {
        this.cached = this.text.apply(this);
        this.hoverText = class_2564.method_10889(this.cached.method_27661(), class_2583.field_24360.method_30938(true));
    }
}
