package dev.amble.ait.client.sounds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import dev.amble.ait.AITMod;

public class SoundHandler {

    private static final List<class_1113> EMPTY = List.of();

    protected List<class_1113> sounds;

    protected void ofSounds(class_1113... sound) {
        if (Arrays.stream(sound).anyMatch(Objects::isNull)) {
            this.sounds = EMPTY;
            return;
        }

        this.sounds = List.of(sound);
    }

    public static SoundHandler create(class_1113... list) {
        SoundHandler handler = new SoundHandler();

        handler.sounds = new ArrayList<>();
        handler.sounds.addAll(List.of(list));

        return handler;
    }

    public void startIfNotPlaying(class_3414 event) {
        if (!isPlaying(event))
            startSound(event);
    }

    public void startIfNotPlaying(class_1113 sound) {
        if (!isPlaying(sound))
            startSound(sound);
    }

    public boolean isPlaying(class_3414 event) {
        return class_310.method_1551().method_1483().method_4877(findSoundByEvent(event));
    }

    public boolean isPlaying(class_1113 sound) {
        return class_310.method_1551().method_1483().method_4877(sound);
    }

    /**
     * Searches through the sounds in this handler and starts playing whichever one
     * matches the SoundEvent given
     *
     * @param event
     *            the event to search for
     */
    public void startSound(class_3414 event) {
        class_1113 sound = findSoundByEvent(event);
        if (sound == null || sound.method_4775() == null) {
            return;
        }

        class_310.method_1551().method_1483().method_4873(sound);
    }

    public void startSound(class_1113 sound) {
if (sound == null || sound.method_4775() == null)
return;
        class_310.method_1551().method_1483().method_4873(sound);
    }

    public void stopSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4870(findSoundByEvent(event));
    }

    public void stopSound(class_1113 sound) {
        class_310.method_1551().method_1483().method_4870(sound);
    }

    public void stopSounds() {
        if (this.sounds == null)
            return;

        for (class_1113 sound : this.sounds) {
            this.stopSound(sound);
        }
    }

    /**
     * Finds the first sound instance that matches the event given FIXME i hate this
     * sm and it doesnt work for sounds which are randomised
     */
    public class_1113 findSoundByEvent(class_3414 event) {
        return findSoundById(event.method_14833());
    }

    public class_1113 findSoundById(class_2960 id) {
        class_2960 temp;

        for (class_1113 sound : this.sounds) {
            temp = sound.method_4775();

            if (temp.equals(id))
                return sound;
        }

        AITMod.LOGGER.error("Could not find sound {} in list, returning empty sound!", id);
        return new PlayerFollowingLoopingSound(class_3417.field_42593, class_3419.field_15254);
    }
}
