package dev.amble.ait.client.sounds.alarm;

import dev.amble.ait.client.sounds.LoopingSound;
import dev.amble.ait.client.sounds.PlayerFollowingLoopingSound;
import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientShakeUtil;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.AITSounds;
import net.minecraft.class_310;
import net.minecraft.class_3419;

// Client only class. One of the last surviving remnants of Duzocode.
public class ClientAlarmHandler extends SoundHandler {

    public static LoopingSound CLOISTER_INTERIOR;

    public LoopingSound getInteriorCloister() {
        if (CLOISTER_INTERIOR == null)
            CLOISTER_INTERIOR = createAlarmSound();

        return CLOISTER_INTERIOR;
    }

    private LoopingSound createAlarmSound() {
        return new PlayerFollowingLoopingSound(AITSounds.CLOISTER, class_3419.field_15256, 10f);
    }

    public static ClientAlarmHandler create() {
        ClientAlarmHandler handler = new ClientAlarmHandler();

        handler.generate();
        return handler;
    }

    private void generate() {
        if (CLOISTER_INTERIOR == null)
            CLOISTER_INTERIOR = createAlarmSound();

        this.ofSounds(CLOISTER_INTERIOR);
    }

    private boolean shouldPlaySound(ClientTardis tardis) {
        return tardis != null && tardis.alarm().isEnabled();
    }

    public void tick(class_310 client) {
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();

        if (this.sounds == null)
            this.generate();

        if (this.shouldPlaySound(tardis)) {
            this.startIfNotPlaying(this.getInteriorCloister());
            ClientShakeUtil.shake(0.15f);
        } else {
            this.stopSounds();
        }
    }
}
