package dev.amble.ait.client.sounds.drifting;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.sounds.PlayerFollowingSound;
import dev.amble.ait.client.sounds.SoundHandler;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.AITSounds;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3419;

// Client only class. One of the last surviving remnants of Duzocode.
public class ClientDriftingSoundHandler extends SoundHandler {

    public static class_1113 DRIFTING;
    private long counter;

    public class_1113 getDrifting() {
        if (DRIFTING == null)
            DRIFTING = createAlarmSound();

        return DRIFTING;
    }

    private class_1113 createAlarmSound() {
        return new PlayerFollowingSound(AITSounds.DRIFTING_MUSIC, class_3419.field_15253, 0.15f);
    }

    public static ClientDriftingSoundHandler create() {
        ClientDriftingSoundHandler handler = new ClientDriftingSoundHandler();

        handler.generate();
        return handler;
    }

    private void generate() {
        if (DRIFTING == null)
            DRIFTING = createAlarmSound();

        this.ofSounds(DRIFTING);
    }

    private boolean shouldPlaySound(ClientTardis tardis) {
        return tardis != null && !tardis.fuel().hasPower();
    }

    public void tick(class_310 client) {
        this.counter++;
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();

        // check the ticks every 2 minutes
        if (client.field_1724 == null && this.counter % (120 * 20) != 0)
            return;

        if (this.sounds == null)
            this.generate();

        if (this.shouldPlaySound(tardis)) {
            if (AITMod.RANDOM.nextBoolean()) {
                this.startIfNotPlaying(this.getDrifting());
            }
            client.method_1538().method_4859();
        } else {
            this.counter = 0;
            this.stopSounds();
        }
    }
}
